/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.converter.Converter;
import ch.systemsx.cisd.common.converter.ConverterPool;
import ch.systemsx.cisd.common.parser.BeanAnalyzer;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.IndexOutOfBoundsException;
import ch.systemsx.cisd.common.parser.MandatoryPropertyMissingException;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.UnmatchedPropertiesException;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractParserObjectFactory<E>
implements IParserObjectFactory<E> {
    protected static final String[] DELETE = new String[]{"--DELETE--", "__DELETE__"};
    private final IPropertyMapper propertyMapper;
    private final ConverterPool converterPool;
    private final Class<E> beanClass;
    private final BeanAnalyzer<E> beanAnalyzer;
    private Set<String> unmatchedProperties;

    protected AbstractParserObjectFactory(Class<E> beanClass, IPropertyMapper propertyMapper) {
        assert (beanClass != null) : "Given bean class can not be null.";
        assert (propertyMapper != null) : "Given property mapper can not be null.";
        this.beanAnalyzer = new BeanAnalyzer<E>(beanClass);
        this.checkPropertyMapper(beanClass, propertyMapper);
        this.propertyMapper = propertyMapper;
        this.converterPool = AbstractParserObjectFactory.createConverterPool();
        this.beanClass = beanClass;
    }

    private static final ConverterPool createConverterPool() {
        return new ConverterPool();
    }

    protected final <T> void registerConverter(Class<T> clazz, Converter<T> converter) {
        if (converter == null) {
            this.converterPool.unregisterConverter(clazz);
        } else {
            this.converterPool.registerConverter(clazz, converter);
        }
    }

    private final <T> T convert(String value, Class<T> type) {
        return this.converterPool.convert(value, type);
    }

    protected final IPropertyModel tryGetPropertyModel(String code) {
        if (this.propertyMapper.containsPropertyCode(code)) {
            return this.propertyMapper.getPropertyModel(code);
        }
        return null;
    }

    protected final String tryGetPropertyDefault(String code) {
        return this.propertyMapper.tryGetPropertyDefault(code);
    }

    private final void checkPropertyMapper(Class<E> clazz, IPropertyMapper propMapper) throws ParserException {
        Set<String> allPropertyCodes = propMapper.getAllPropertyCodes();
        LinkedHashSet<String> propertyCodes = new LinkedHashSet<String>(allPropertyCodes);
        LinkedHashSet<String> missingProperties = new LinkedHashSet<String>();
        Set<String> fieldNames = this.beanAnalyzer.getLabelToWriteMethods().keySet();
        for (String fieldName : fieldNames) {
            String fieldNameInLowerCase = fieldName.toLowerCase();
            if (propertyCodes.contains(fieldNameInLowerCase)) {
                propertyCodes.remove(fieldNameInLowerCase);
                continue;
            }
            if (!this.beanAnalyzer.isMandatory(fieldName)) continue;
            missingProperties.add(fieldName);
        }
        Set<String> mandatoryPropertyCodes = this.beanAnalyzer.getMandatoryProperties();
        if (missingProperties.size() > 0) {
            throw new MandatoryPropertyMissingException(mandatoryPropertyCodes, missingProperties);
        }
        if (propertyCodes.size() > 0 && !this.ignoreUnmatchedProperties()) {
            throw new UnmatchedPropertiesException(mandatoryPropertyCodes, this.beanAnalyzer.getOptionalProperties(), propertyCodes);
        }
        this.unmatchedProperties = propertyCodes;
    }

    protected final String getPropertyValue(String[] lineTokens, IPropertyModel propertyModel, String propertyDefault) {
        int column = propertyModel.getColumn();
        if (StringUtils.isBlank((CharSequence)propertyDefault) && (column >= lineTokens.length || column < 0)) {
            throw new IndexOutOfBoundsException(column, lineTokens);
        }
        String value = null;
        if (column < 0) {
            value = propertyDefault;
        } else {
            value = lineTokens[column];
            if (StringUtils.isBlank((CharSequence)value) && AbstractParserObjectFactory.isNotEmpty(propertyDefault)) {
                value = propertyDefault;
            }
        }
        this.checkMandatory(value, propertyModel.getCode());
        return value;
    }

    protected static boolean isEmpty(String value) {
        return !AbstractParserObjectFactory.isNotEmpty(value);
    }

    protected static boolean isEmpty(String[] values) {
        return !AbstractParserObjectFactory.isNotEmpty(values);
    }

    protected static boolean isNotEmpty(String value) {
        return !StringUtils.isBlank((CharSequence)value);
    }

    protected static boolean isNotEmpty(String[] values) {
        return values != null && values.length > 0 && AbstractParserObjectFactory.isNotEmpty(values[0]);
    }

    protected static boolean isDeletionMark(String value) {
        return DELETE[0].equals(value) || DELETE[1].equals(value);
    }

    protected static boolean isDeletionMark(String[] values) {
        return values != null && values.length > 0 && AbstractParserObjectFactory.isDeletionMark(values[0]);
    }

    private void checkMandatory(String value, String code) {
        if (this.beanAnalyzer.isMandatory(code) && StringUtils.isBlank((CharSequence)value)) {
            throw new MandatoryPropertyMissingException(code);
        }
    }

    protected boolean ignoreUnmatchedProperties() {
        return false;
    }

    protected boolean isColumnAvailable(String columnName) {
        return this.tryGetPropertyModel(columnName) != null;
    }

    protected final Set<String> getUnmatchedProperties() {
        return this.unmatchedProperties;
    }

    @Override
    public E createObject(String[] lineTokens) throws ParserException {
        assert (lineTokens != null) : "Unspecified line tokens";
        Object object = ClassUtils.createInstance(this.beanClass);
        for (Map.Entry<String, Method> entry : this.beanAnalyzer.getLabelToWriteMethods().entrySet()) {
            Method writeMethod = entry.getValue();
            IPropertyModel propertyModel = this.tryGetPropertyModel(entry.getKey());
            String propertyDefault = this.tryGetPropertyDefault(entry.getKey());
            if (propertyModel == null) continue;
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel, propertyDefault);
            ClassUtils.invokeMethod((Method)writeMethod, (Object)object, (Object[])new Object[]{this.convert(propertyValue, writeMethod.getParameterTypes()[0])});
        }
        return (E)object;
    }
}

