/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ILineTokenizer;
import ch.systemsx.cisd.common.parser.MultilineSupport;
import ch.systemsx.cisd.common.parser.ParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class ApacheLineTokenizer
implements ILineTokenizer<String> {
    public void init() {
    }

    public String[] tokenize(String line) throws ParserException {
        try {
            CSVParser parser = CSVParser.parse((String)line, (CSVFormat)MultilineSupport.FORMAT);
            List records = parser.getRecords();
            if (records.size() != 1) {
                throw new ParserException("Found wrong number of records on line " + line + ": " + parser.getRecords().size());
            }
            CSVRecord record = (CSVRecord)records.get(0);
            Iterator iter = record.iterator();
            ArrayList<String> items = new ArrayList<String>();
            while (iter.hasNext()) {
                items.add((String)iter.next());
            }
            return items.toArray(new String[0]);
        }
        catch (IOException e) {
            throw new ParserException("Failed to parse string " + line, (Throwable)e);
        }
    }

    public void destroy() {
    }
}

