/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.MappedProperty;
import ch.systemsx.cisd.common.string.StringUtilities;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class DefaultPropertyMapper
implements IPropertyMapper {
    private static final String IGNORED_COLUMN_PREFIX = "!";
    private final TableMap<String, IPropertyModel> propertyModels;
    private final Map<String, String> defaults;

    public DefaultPropertyMapper(String[] properties, Map<String, String> defaults) throws IllegalArgumentException {
        assert (properties != null) : "Unspecified properties";
        this.defaults = defaults == null ? Collections.emptyMap() : defaults;
        this.propertyModels = new TableMap((IKeyExtractor)new IKeyExtractor<String, IPropertyModel>(){

            public final String getKey(IPropertyModel e) {
                return e.getCode().toLowerCase();
            }
        });
        this.tokensToMap(properties);
    }

    private final void tokensToMap(String[] properties) throws IllegalArgumentException {
        int i;
        int len = properties.length;
        for (i = 0; i < len; ++i) {
            String token = properties[i];
            if (StringUtils.isBlank((CharSequence)token)) {
                throw new IllegalArgumentException(String.format("%s token of %s is blank.", StringUtilities.getOrdinal((int)i), Arrays.asList(properties)));
            }
            if (token.startsWith(IGNORED_COLUMN_PREFIX)) continue;
            this.propertyModels.add((Object)new MappedProperty(i, token));
        }
        i = -1;
        for (String defaultKey : this.defaults.keySet()) {
            if (this.propertyModels.tryGet((Object)defaultKey) != null) continue;
            this.propertyModels.add((Object)new MappedProperty(i--, defaultKey));
        }
    }

    @Override
    public final boolean containsPropertyCode(String propertyCode) {
        return this.propertyModels.tryGet((Object)propertyCode.toLowerCase()) != null;
    }

    @Override
    public final Set<String> getAllPropertyCodes() {
        return new TreeSet<String>(this.propertyModels.keySet());
    }

    @Override
    public final IPropertyModel getPropertyModel(String propertyCode) throws IllegalArgumentException {
        if (!this.containsPropertyCode(propertyCode)) {
            throw new IllegalArgumentException(String.format("Given property '%s' does not exist.", propertyCode));
        }
        return (IPropertyModel)this.propertyModels.tryGet((Object)propertyCode.toLowerCase());
    }

    @Override
    public String tryGetPropertyDefault(String propertyCode) {
        return this.defaults.get(propertyCode);
    }
}

