/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.DefaultParser;
import ch.systemsx.cisd.common.parser.DefaultPropertyMapper;
import ch.systemsx.cisd.common.parser.ExcelRow;
import ch.systemsx.cisd.common.parser.ExcelRowTokenizer;
import ch.systemsx.cisd.common.parser.ILine;
import ch.systemsx.cisd.common.parser.IParser;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import ch.systemsx.cisd.common.parser.filter.AlwaysAcceptLineFilter;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelFileLoader<T> {
    public static final String COMMENT_PREFIX = "#";
    public static final Pattern COMMENT_REGEXP_PATTERN = Pattern.compile("\"*#.*");
    public static final String DEFAULT_SECTION = "[DEFAULT]";
    private final IParserObjectFactoryFactory<T> factory;

    public ExcelFileLoader(final Class<T> beanClass) {
        this.factory = new IParserObjectFactoryFactory<T>(){

            @Override
            public IParserObjectFactory<T> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new AbstractParserObjectFactory<T>(beanClass, propertyMapper){};
            }
        };
    }

    public ExcelFileLoader(IParserObjectFactoryFactory<T> factory) {
        assert (factory != null) : "Undefined factory";
        this.factory = factory;
    }

    public List<T> load(Sheet sheet, int begin, int end, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        assert (sheet != null) : "Unspecified reader";
        Iterator<ILine<Row>> rowIterator = ExcelFileLoader.createRowIterator(sheet, begin, end);
        return this.load(rowIterator, defaults);
    }

    public static final Map<String, String> parseDefaults(Sheet sheet, int begin, int end) {
        Iterator<ILine<Row>> lineIterator = ExcelFileLoader.createRowIterator(sheet, begin, end);
        HashMap<String, String> defaults = new HashMap<String, String>();
        return ExcelFileLoader.parseDefaults(lineIterator, defaults);
    }

    private static final Map<String, String> parseDefaults(Iterator<ILine<Row>> rowIterator, Map<String, String> defaults) {
        ILine<Row> row;
        while (rowIterator.hasNext() && !ExcelFileLoader.startsDefaultSection(row = rowIterator.next())) {
            String[] tokens = ExcelRowTokenizer.tokenizeRow((Row)row.getObject());
            if (tokens.length < 2) continue;
            String name = tokens[0];
            String value = tokens[1];
            defaults.put(name.toLowerCase(), value);
        }
        return defaults;
    }

    private List<T> load(Iterator<ILine<Row>> lineIterator, Map<String, String> fileDefaults) {
        ILine<Row> previousLine = null;
        ILine<Row> line = null;
        ILine<Row> headerLine = null;
        ILine<Row> firstContentLine = null;
        HashMap<String, String> defaults = new HashMap<String, String>(fileDefaults);
        while (lineIterator.hasNext()) {
            if (previousLine != null && ExcelFileLoader.isEmptyComment(previousLine) && line != null && !ExcelFileLoader.isEmptyComment(line)) {
                headerLine = line;
            }
            previousLine = line;
            line = lineIterator.next();
            if (ExcelFileLoader.isComment(line)) continue;
            if (ExcelFileLoader.startsDefaultSection(line)) {
                ExcelFileLoader.parseDefaults(lineIterator, defaults);
                continue;
            }
            if (headerLine == null) {
                headerLine = line;
                break;
            }
            firstContentLine = line;
            break;
        }
        if (line == null) {
            return new ArrayList();
        }
        IParser<T, Row> parser = this.createParser();
        String[] tokens = headerLine != null ? ExcelRowTokenizer.tokenizeRow(ExcelFileLoader.trimComment(headerLine)) : new String[]{};
        int headerLength = tokens.length;
        ExcelFileLoader.notUnique(tokens);
        DefaultPropertyMapper propertyMapper = new DefaultPropertyMapper(tokens, defaults);
        parser.setObjectFactory(this.factory.createFactory(propertyMapper));
        Iterator contentLineIterator = ExcelFileLoader.createContentIterator(firstContentLine, lineIterator);
        ILineFilter filter = AlwaysAcceptLineFilter.INSTANCE;
        return parser.parse(contentLineIterator, filter, headerLength);
    }

    private static boolean startsDefaultSection(Row row) {
        Cell cell = row.getCell(0);
        if (cell == null || cell.getCellType() != 1) {
            return false;
        }
        return DEFAULT_SECTION.equals(cell.getStringCellValue().trim());
    }

    private static boolean startsDefaultSection(ILine<Row> row) {
        return ExcelFileLoader.startsDefaultSection((Row)row.getObject());
    }

    private static Row trimComment(ILine<Row> previousLine) {
        if (ExcelFileLoader.isComment(previousLine)) {
            Cell firstCell = ((Row)previousLine.getObject()).getCell(0);
            firstCell.setCellValue(firstCell.getStringCellValue().substring(COMMENT_PREFIX.length()));
        }
        return (Row)previousLine.getObject();
    }

    private static boolean isComment(ILine<Row> line) {
        Row row = (Row)line.getObject();
        return row.getCell(0) != null && row.getCell(0).toString().startsWith(COMMENT_PREFIX);
    }

    private static boolean isEmptyComment(ILine<Row> line) {
        if (ExcelFileLoader.isComment(line)) {
            Row row = ExcelFileLoader.trimComment(line);
            return row.getCell(0) == null || row.getCell(0).getStringCellValue() == null || row.getCell(0).getStringCellValue().trim().length() == 0;
        }
        return false;
    }

    private static Iterator<ILine<Row>> createContentIterator(final ILine<Row> firstContentLineOrNull, final Iterator<ILine<Row>> lineIterator) {
        return new Iterator<ILine<Row>>(){
            private ILine<Row> firstLineOrNull;
            {
                this.firstLineOrNull = firstContentLineOrNull;
            }

            @Override
            public boolean hasNext() {
                return this.firstLineOrNull != null || lineIterator.hasNext();
            }

            @Override
            public ILine<Row> next() {
                return this.nextLine();
            }

            private ILine<Row> nextLine() {
                if (this.firstLineOrNull != null) {
                    ILine<Row> line = this.firstLineOrNull;
                    this.firstLineOrNull = null;
                    return line;
                }
                return (ILine)lineIterator.next();
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }
        };
    }

    private static Iterator<ILine<Row>> createRowIterator(Sheet sheet, int begin, int end) {
        return new ExcelFileRowIterator(sheet, begin, end);
    }

    private static final void notUnique(String[] tokens) {
        assert (tokens != null) : "Given tokens can not be null.";
        HashSet<String> unique = new HashSet<String>();
        for (String token : tokens) {
            if (unique.add(token.toLowerCase())) continue;
            throw new IllegalArgumentException(String.format("Duplicated column name '%s': %s", token, Arrays.asList(tokens)));
        }
    }

    private final <E> IParser<E, Row> createParser() {
        ExcelRowTokenizer tokenizer = new ExcelRowTokenizer();
        return new DefaultParser(tokenizer);
    }

    private static final class ExcelFileRowIterator
    implements Iterator<ILine<Row>> {
        private final Sheet sheet;
        private int current;
        private final int end;

        private ExcelFileRowIterator(Sheet sheet, int begin, int end) {
            this.sheet = sheet;
            this.current = begin;
            this.end = end;
            this.getFirstNonEmptyCurrent();
        }

        private void getFirstNonEmptyCurrent() {
            while (this.sheet.getRow(this.current) == null && this.current <= this.end) {
                ++this.current;
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ILine<Row> next() {
            try {
                ExcelRow excelRow = new ExcelRow(this.sheet.getRow(this.current));
                return excelRow;
            }
            finally {
                ++this.current;
                this.getFirstNonEmptyCurrent();
            }
        }

        @Override
        public final boolean hasNext() {
            return this.current <= this.end;
        }
    }
}

