/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemorySizeFormatter {
    public static long parse(String size) {
        for (Format format : Format.values()) {
            if (!format.canParse(size)) continue;
            return format.parse(size);
        }
        throw new IllegalArgumentException("Could not parse memory size value: " + size);
    }

    public static String format(long size) {
        for (Format format : Format.values()) {
            if (!format.canFormat(size)) continue;
            return format.format(size);
        }
        throw new IllegalArgumentException("Could not format memory size value: " + size);
    }

    private static enum Format {
        ZERO("(0+)\\s*(|b|B)", "", 0){

            @Override
            public boolean canFormat(long size) {
                return size == 0L;
            }
        }
        ,
        BYTE("([0-9]+)\\s*(|b|B)", "b", 0),
        KILO("([0-9]+)\\s*(k|K)", "k", 1),
        MEGA("([0-9]+)\\s*(m|M)", "m", 2),
        GIGA("([0-9]+)\\s*(g|G)", "g", 3),
        TERA("([0-9]+)\\s*(t|T)", "t", 4){

            @Override
            public boolean canFormat(long size) {
                return size > 0L;
            }
        };

        private Pattern parsePattern;
        private String formatUnit;
        private int power;

        private Format() {
        }

        private Format(String parsePattern, String formatUnit, int power) {
            this.parsePattern = Pattern.compile(parsePattern);
            this.formatUnit = formatUnit;
            this.power = power;
        }

        public boolean canParse(String size) {
            return this.parsePattern.matcher(size).matches();
        }

        public long parse(String size) {
            Matcher m = this.parsePattern.matcher(size);
            m.matches();
            long value = Long.valueOf(m.group(1));
            long factor = (long)Math.pow(1024.0, this.power);
            return value * factor;
        }

        public boolean canFormat(long size) {
            long lowerBound = (long)Math.pow(1024.0, this.power);
            long upperBound = (long)Math.pow(1024.0, this.power + 1);
            return lowerBound <= size && size < upperBound;
        }

        public String format(long size) {
            double factor = Math.pow(1024.0, this.power);
            double value = (double)size / factor;
            if (Math.abs(value - (double)Math.round(value)) < 0.1) {
                return String.format("%d", Math.round(value)) + this.formatUnit;
            }
            return String.format("%.1f", value) + this.formatUnit;
        }
    }
}

