/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.exceptions.HighLevelException;
import java.util.Arrays;

public class ParsingException
extends HighLevelException {
    static final String MESSAGE_FORMAT = "Creating an object with following tokens '%s' failed.";
    private static final long serialVersionUID = 1L;
    private final int lineNumber;
    private final String[] tokens;

    public ParsingException(String[] tokens, int lineNumber) {
        this(null, tokens, lineNumber);
    }

    public ParsingException(RuntimeException cause, String[] tokens, int lineNumber) {
        super(ParsingException.createMessage(tokens), (Throwable)cause);
        this.lineNumber = lineNumber;
        this.tokens = tokens;
    }

    private static final String createMessage(String[] tokens) {
        assert (tokens != null) : "Tokens can not be null.";
        return String.format(MESSAGE_FORMAT, Arrays.asList(tokens));
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final String[] getTokens() {
        return this.tokens;
    }

    public final RuntimeException getCauseRuntimeException() {
        return (RuntimeException)this.getCause();
    }
}

