/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.collection.CollectionStyle;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.parser.ParserException;
import java.util.Set;

public final class UnmatchedPropertiesException
extends ParserException {
    private static final long serialVersionUID = 1L;

    public UnmatchedPropertiesException(Set<String> mandatoryNames, Set<String> optionalNames, Set<String> propertyNames) {
        super(UnmatchedPropertiesException.createMessage(propertyNames, mandatoryNames, optionalNames));
    }

    private static final String createMessage(Set<String> propertyNames, Set<String> mandatoryNames, Set<String> optionalNames) {
        boolean hasMandatory;
        assert (propertyNames != null) : "Property names can not be null.";
        assert (propertyNames.size() > 0) : "There is no reason to throw this exception.";
        StringBuilder builder = new StringBuilder();
        builder.append("Columns ").append(UnmatchedPropertiesException.toString(propertyNames)).append(" specified in the header are not expected (");
        boolean bl = hasMandatory = mandatoryNames.size() > 0;
        if (hasMandatory) {
            builder.append("mandatory colums are ");
            builder.append(UnmatchedPropertiesException.toString(mandatoryNames));
        }
        if (optionalNames.size() > 0) {
            if (hasMandatory) {
                builder.append(", ");
            }
            builder.append("optional colums are ");
            builder.append(UnmatchedPropertiesException.toString(optionalNames));
        }
        builder.append(")");
        return builder.toString();
    }

    private static final String toString(Set<String> set) {
        return CollectionUtils.abbreviate(set, (int)-1, (CollectionStyle)CollectionStyle.SINGLE_QUOTE_BOUNDARY);
    }
}

