/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.resource;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.resource.IReleasable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class Resources {
    private Logger logger = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, this.getClass());
    public Set<IReleasable> resources = new LinkedHashSet<IReleasable>();

    public void add(Object resource) {
        if (resource instanceof IReleasable) {
            this.resources.add((IReleasable)resource);
        }
    }

    public void release() {
        if (this.resources.size() > 0) {
            for (IReleasable resource : this.resources) {
                try {
                    resource.release();
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Successfully released a resource: " + resource));
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Couldn't release a resource: " + resource), (Throwable)e);
                }
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Didn't have to release any resources");
        }
        this.resources.clear();
    }
}

