/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;

public class PasswordHasher {
    private static final int SALT_LENGTH = 4;

    private static byte[] createSalt() {
        Random rng = new Random();
        byte[] result = new byte[4];
        rng.nextBytes(result);
        return result;
    }

    private static byte[] computeSaltedSHA1Hash(String password, byte[] salt) {
        assert (password != null) : "Unspecified password.";
        try {
            MessageDigest algorithm = MessageDigest.getInstance("SHA1");
            algorithm.update(salt);
            algorithm.update(password.getBytes("utf8"));
            return algorithm.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error("SHA1 hashing algorithms not supported.");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error("UTF8 encoding is not supported.");
        }
    }

    private static String computeHashedPassword(String password, byte[] salt) {
        byte[] encoded = PasswordHasher.computeSaltedSHA1Hash(password, salt);
        byte[] encodedWithSalt = ArrayUtils.addAll((byte[])salt, (byte[])encoded);
        return PasswordHasher.encodeBase64(encodedWithSalt);
    }

    private static byte[] getSaltFromPassword(byte[] saltedHashedPassword) {
        return ArrayUtils.subarray((byte[])saltedHashedPassword, (int)0, (int)4);
    }

    private static byte[] getHashFromPassword(byte[] saltedHashedPassword) {
        return ArrayUtils.subarray((byte[])saltedHashedPassword, (int)4, (int)saltedHashedPassword.length);
    }

    private static String encodeBase64(byte[] base64Data) {
        try {
            return new String(Base64.encodeBase64((byte[])base64Data), "utf8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error("UTF8 encoding is not supported.");
        }
    }

    private static byte[] decodeBase64(String string) {
        try {
            return Base64.decodeBase64((byte[])string.getBytes("utf8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error("UTF8 encoding is not supported.");
        }
    }

    public static String computeSaltedHash(String password) {
        byte[] salt = PasswordHasher.createSalt();
        return PasswordHasher.computeHashedPassword(password, salt);
    }

    public static boolean isPasswordCorrect(String password, String saltedHash) {
        byte[] reference = PasswordHasher.decodeBase64(saltedHash);
        byte[] salt = PasswordHasher.getSaltFromPassword(reference);
        byte[] hashReference = PasswordHasher.getHashFromPassword(reference);
        byte[] hashtoCheck = PasswordHasher.computeSaltedSHA1Hash(password, salt);
        return Arrays.equals(hashtoCheck, hashReference);
    }
}

