/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.client;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.TimeoutExceptionUnchecked;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceConversationDTO;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.UnexpectedMessagePayloadException;
import ch.systemsx.cisd.common.serviceconversation.client.ClientResponseMessageMultiplexer;
import ch.systemsx.cisd.common.serviceconversation.client.ClientResponseMessageQueue;
import ch.systemsx.cisd.common.serviceconversation.client.IServiceConversation;
import ch.systemsx.cisd.common.serviceconversation.client.IServiceMessageTransportWithControl;
import ch.systemsx.cisd.common.serviceconversation.client.ServiceExecutionException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

class ClientMessenger
implements IServiceConversation {
    private final IServiceMessageTransport transportToService;
    private final String serviceConversationId;
    private final ClientResponseMessageQueue responseMessageQueue;
    private final ClientResponseMessageMultiplexer responseMessageMultiplexer;
    private final int serviceMessageTimeoutMillis;
    private final int serverWorkQueueSizeAtStartup;
    private int outgoingMessageIdx;
    private final AtomicBoolean serviceExceptionSignaled = new AtomicBoolean();
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ClientMessenger.class);

    ClientMessenger(ServiceConversationDTO serviceConversationDTO, IServiceMessageTransport transportToService, ClientResponseMessageQueue responseMessageQueue, ClientResponseMessageMultiplexer responseMessageMultiplexer) {
        assert (transportToService != null);
        this.serviceConversationId = serviceConversationDTO.getServiceConversationId();
        assert (this.serviceConversationId != null);
        this.serviceMessageTimeoutMillis = serviceConversationDTO.getClientTimeoutInMillis();
        this.serverWorkQueueSizeAtStartup = serviceConversationDTO.getWorkQueueSize();
        this.transportToService = transportToService;
        this.responseMessageQueue = responseMessageQueue;
        this.responseMessageMultiplexer = responseMessageMultiplexer;
        responseMessageMultiplexer.addConversation(this.serviceConversationId, new IServiceMessageTransportWithControl(){

            @Override
            public void send(ServiceMessage message) {
                ClientMessenger.this.responseMessageQueue.send(message);
            }

            @Override
            public void sendException(ServiceMessage message) {
                ClientMessenger.this.serviceExceptionSignaled.set(true);
                ClientMessenger.this.responseMessageQueue.send(message);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Serializable message) {
        this.checkServiceException();
        ClientMessenger clientMessenger = this;
        synchronized (clientMessenger) {
            this.transportToService.send(new ServiceMessage(this.serviceConversationId, this.nextOutgoingMessageIndex(), false, message));
        }
    }

    private void checkServiceException() throws ServiceExecutionException {
        if (this.serviceExceptionSignaled.getAndSet(false)) {
            try {
                ServiceMessage messageOrNull = this.responseMessageQueue.poll(0);
                if (messageOrNull != null && messageOrNull.isException()) {
                    throw new ServiceExecutionException(messageOrNull.getConversationId(), messageOrNull.tryGetExceptionDescription());
                }
            }
            catch (InterruptedException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        ClientMessenger clientMessenger = this;
        synchronized (clientMessenger) {
            this.transportToService.send(ServiceMessage.terminate(this.serviceConversationId));
        }
    }

    @Override
    public int getServerWorkQueueSizeAtStartup() {
        return this.serverWorkQueueSizeAtStartup;
    }

    @Override
    public <T extends Serializable> T receive(Class<T> messageClass) {
        try {
            return (T)((Serializable)this.handleMessage(this.getMessage(this.serviceMessageTimeoutMillis), messageClass, true));
        }
        catch (InterruptedException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public <T extends Serializable> T tryReceive(Class<T> messageClass, int timeoutMillis) {
        try {
            return (T)((Serializable)this.handleMessage(this.getMessage(timeoutMillis), messageClass, false));
        }
        catch (InterruptedException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private ServiceMessage getMessage(int timeout) throws InterruptedException {
        ServiceMessage message = this.responseMessageQueue.poll(timeout);
        while (message != null && message.getProgress() != null) {
            operationLog.debug((Object)message.getProgress());
            message = this.responseMessageQueue.poll(timeout);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleMessage(ServiceMessage message, Class<T> messageClass, boolean throwExceptionOnNull) {
        if (message == null) {
            if (throwExceptionOnNull) {
                TimeoutExceptionUnchecked exception = new TimeoutExceptionUnchecked("Timeout while waiting on message from service.");
                String exceptionDescription = ServiceExecutionException.getDescriptionFromException((Throwable)exception);
                try {
                    ClientMessenger clientMessenger = this;
                    synchronized (clientMessenger) {
                        this.transportToService.send(new ServiceMessage(this.serviceConversationId, this.nextOutgoingMessageIndex(), true, (Serializable)((Object)exceptionDescription)));
                    }
                }
                catch (RuntimeException ex) {
                    operationLog.warn((Object)"Sending time out exception failed", (Throwable)ex);
                }
                throw exception;
            }
            return null;
        }
        if (message.isException()) {
            throw new ServiceExecutionException(message.getConversationId(), message.tryGetExceptionDescription());
        }
        Serializable payload = message.getPayload();
        if (messageClass != null && payload != null && !messageClass.isAssignableFrom(payload.getClass())) {
            throw new UnexpectedMessagePayloadException(payload.getClass(), messageClass);
        }
        return (T)payload;
    }

    private int nextOutgoingMessageIndex() {
        return this.outgoingMessageIdx++;
    }

    @Override
    public String getId() {
        return this.serviceConversationId;
    }

    @Override
    public void close() {
        this.responseMessageMultiplexer.removeConversation(this.serviceConversationId);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

