/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.servlet;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class MethodFilter
implements Filter {
    public static final String ALLOWED_METHODS_PARAMETER = "allowed-methods";
    private Set<String> allowedMethods = new HashSet<String>();

    public void init(FilterConfig config) throws ServletException {
        String allowedMethodsAsString = config.getInitParameter(ALLOWED_METHODS_PARAMETER);
        if (allowedMethodsAsString != null) {
            for (String method : allowedMethodsAsString.split(",")) {
                this.allowedMethods.add(method.trim().toUpperCase());
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if (this.allowedMethods.contains(method.toUpperCase())) {
            filterChain.doFilter(request, response);
        } else {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader("Allow", StringUtils.collectionToDelimitedString(this.allowedMethods, (String)", "));
            httpResponse.sendError(405, "Method '" + method + "' is not allowed");
        }
    }

    public void destroy() {
    }
}

