/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;

public class Bootstrapper
implements ApplicationContextAware,
InitializingBean {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, Bootstrapper.class);
    private AbstractRefreshableConfigApplicationContext context;
    private String[] configLocations;
    private String[] conditionalConfigLocations;

    public void setConfigLocation(String configLocation) {
        this.configLocations = new String[]{configLocation};
    }

    public void setConditionalConfigLocations(String[] conditionalConfigLocations) {
        this.conditionalConfigLocations = conditionalConfigLocations;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (AbstractRefreshableConfigApplicationContext)applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        ArrayList<String> allConfigLocations = new ArrayList<String>();
        for (String configLocation : this.configLocations) {
            allConfigLocations.add(configLocation);
        }
        if (this.conditionalConfigLocations != null) {
            for (String conditionalConfigLocationString : this.conditionalConfigLocations) {
                String condition;
                int index = conditionalConfigLocationString.indexOf(":");
                if (index == -1 || !Bootstrapper.evaluateCondition(condition = conditionalConfigLocationString.substring(0, index))) continue;
                allConfigLocations.add(conditionalConfigLocationString.substring(index + 1));
            }
        }
        operationLog.info((Object)("Refreshing application context with " + allConfigLocations));
        this.context.setConfigLocations(allConfigLocations.toArray(new String[allConfigLocations.size()]));
        this.context.refresh();
        operationLog.info((Object)("Refreshed application context with " + allConfigLocations));
    }

    private static boolean evaluateCondition(String condition) {
        return condition.trim().toLowerCase().equals("true");
    }
}

