/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.common.spring.WhiteAndBlackListCodebaseAwareObjectInputStream;
import ch.systemsx.cisd.common.spring.WhiteAndBlackListHttpInvokerServiceExporter;
import ch.systemsx.cisd.common.spring.WhiteAndBlackListStreamSupportingHttpInvokerExporter;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;

public class CheckSecureHttpInvokerBeanPostProcessor
implements BeanPostProcessor,
InitializingBean {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CheckSecureHttpInvokerBeanPostProcessor.class);
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;

    private static boolean isBeanSecure(Object bean) {
        if (!(bean instanceof HttpInvokerServiceExporter)) {
            return true;
        }
        if (bean instanceof WhiteAndBlackListHttpInvokerServiceExporter || bean instanceof WhiteAndBlackListStreamSupportingHttpInvokerExporter) {
            operationLog.info((Object)("Secure HTTP invoker service exporter: " + bean));
            return true;
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configurer == null) {
            return;
        }
        WhiteAndBlackListCodebaseAwareObjectInputStream.populateWhiteAndBlackListOfApiParameterClasses(this.configurer.getResolvedProps());
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!CheckSecureHttpInvokerBeanPostProcessor.isBeanSecure(bean)) {
            throw new InsecureHttpInvokerServiceExporterException("Bean " + beanName + " is an instance of unsecure type HttpInvokerServiceExporter");
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public class InsecureHttpInvokerServiceExporterException
    extends BeanDefinitionValidationException {
        private static final long serialVersionUID = 1L;

        public InsecureHttpInvokerServiceExporterException(String msg) {
            super(msg);
        }
    }
}

