/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.properties.ExtendedProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.Constants;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringUtils;

public class ExposablePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    public static final String PROPERTY_CONFIGURER_BEAN_NAME = "propertyConfigurer";
    private Properties resolvedProps;
    private int systemPropertiesMode = 1;
    private static final Constants constants = new Constants(PropertyPlaceholderConfigurer.class);

    public final Properties getResolvedProps() {
        return this.resolvedProps;
    }

    protected final String convertPropertyValue(String originalValue) {
        return StringUtils.trimWhitespace((String)originalValue);
    }

    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        this.setSystemPropertiesMode(constants.asNumber(constantName).intValue());
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
        super.setSystemPropertiesMode(systemPropertiesMode);
    }

    public Map<String, String> getDefaultValuesForMissingProperties() {
        return new HashMap<String, String>();
    }

    protected final void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        this.resolvedProps = new ExtendedProperties();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            this.resolvedProps.setProperty(keyStr, this.getResolvedProperty(props, keyStr));
        }
        Map<String, String> defaultValues = this.getDefaultValuesForMissingProperties();
        for (String key : defaultValues.keySet()) {
            if (this.resolvedProps.containsKey(key)) continue;
            this.resolvedProps.setProperty(key, defaultValues.get(key));
        }
        this.injectPropertiesInto(this.resolvedProps);
        super.processProperties(beanFactoryToProcess, this.resolvedProps);
    }

    protected void injectPropertiesInto(Properties properties) {
    }

    private String getResolvedProperty(final Properties props, String key) {
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, this.ignoreUnresolvablePlaceholders);
        String resolvedPlaceholder = this.resolvePlaceholder(key, props, this.systemPropertiesMode);
        return helper.replacePlaceholders(resolvedPlaceholder, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                return ExposablePropertyPlaceholderConfigurer.this.resolvePlaceholder(placeholderName, props, ExposablePropertyPlaceholderConfigurer.this.systemPropertiesMode);
            }
        });
    }
}

