/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.http.JettyHttpClientFactory;
import ch.systemsx.cisd.common.spring.IRemoteSpringBeanProvider;
import ch.systemsx.cisd.common.spring.JettyRemoteSpringBeanProvider;
import com.marathon.util.spring.StreamSupportingHttpInvokerProxyFactoryBean;
import com.marathon.util.spring.StreamSupportingHttpInvokerRequestExecutor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;

public class HttpInvokerUtils {
    public static IRemoteSpringBeanProvider provider;
    private static SSLConnectionSocketFactory sf;

    private static SSLConnectionSocketFactory initializeSSLConnectionFactory() {
        try {
            return new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T createServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        if (HttpInvokerUtils.checkAndInitializeJettyProvider()) {
            return provider.create(serviceInterface, serviceURL, serverTimeoutInMillis);
        }
        return HttpInvokerUtils.createApacheServiceStub(serviceInterface, serviceURL, serverTimeoutInMillis);
    }

    public static <T> T createStreamSupportingServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        if (HttpInvokerUtils.checkAndInitializeJettyProvider()) {
            return provider.create(serviceInterface, serviceURL, serverTimeoutInMillis);
        }
        return HttpInvokerUtils.createStreamSupportingApacheServiceStub(serviceInterface, serviceURL, serverTimeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkAndInitializeJettyProvider() {
        try {
            Class.forName("org.eclipse.jetty.client.HttpClient", false, HttpInvokerUtils.class.getClassLoader());
            Class<HttpInvokerUtils> clazz = HttpInvokerUtils.class;
            synchronized (HttpInvokerUtils.class) {
                if (provider == null) {
                    provider = new JettyRemoteSpringBeanProvider(JettyHttpClientFactory.getHttpClient());
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static <T> T createApacheServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        HttpInvokerProxyFactoryBean httpInvokerProxy = new HttpInvokerProxyFactoryBean();
        Registry schemeRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sf).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(5);
        CloseableHttpClient client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).useSystemProperties().setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).build();
        HttpComponentsHttpInvokerRequestExecutor httpInvokerRequestExecutor = new HttpComponentsHttpInvokerRequestExecutor((HttpClient)client);
        httpInvokerProxy.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)httpInvokerRequestExecutor);
        httpInvokerProxy.setBeanClassLoader(serviceInterface.getClassLoader());
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceInterface);
        httpInvokerRequestExecutor.setReadTimeout((int)serverTimeoutInMillis);
        InetSocketAddress proxyAddressOrNull = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddressOrNull != null) {
            HttpHost proxy = new HttpHost(proxyAddressOrNull.getHostName(), proxyAddressOrNull.getPort(), "http");
            CloseableHttpClient client2 = HttpClientBuilder.create().setProxy(proxy).useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).build();
            httpInvokerRequestExecutor.setHttpClient((HttpClient)client2);
        }
        httpInvokerProxy.afterPropertiesSet();
        return HttpInvokerUtils.getCastedService(httpInvokerProxy);
    }

    private static <T> T createStreamSupportingApacheServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        StreamSupportingHttpInvokerProxyFactoryBean httpInvokerProxy = new StreamSupportingHttpInvokerProxyFactoryBean();
        httpInvokerProxy.setBeanClassLoader(serviceInterface.getClassLoader());
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceInterface);
        Registry schemeRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sf).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(5);
        StreamSupportingHttpInvokerRequestExecutor httpInvokerRequestExecutor = (StreamSupportingHttpInvokerRequestExecutor)httpInvokerProxy.getHttpInvokerRequestExecutor();
        httpInvokerRequestExecutor.setReadTimeout((int)serverTimeoutInMillis);
        InetSocketAddress proxyAddressOrNull = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddressOrNull != null) {
            HttpHost proxy = new HttpHost(proxyAddressOrNull.getHostName(), proxyAddressOrNull.getPort(), "http");
            CloseableHttpClient client2 = HttpClientBuilder.create().setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).setProxy(proxy).useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            httpInvokerRequestExecutor.setHttpClient((HttpClient)client2);
        } else {
            httpInvokerRequestExecutor.setHttpClient((HttpClient)HttpClientBuilder.create().setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).build());
        }
        httpInvokerProxy.afterPropertiesSet();
        return HttpInvokerUtils.getCastedService((HttpInvokerProxyFactoryBean)httpInvokerProxy);
    }

    public static final <T> T getCastedService(HttpInvokerProxyFactoryBean httpInvokerProxy) {
        return (T)httpInvokerProxy.getObject();
    }

    public static InetSocketAddress tryFindProxy(String serviceURL) {
        try {
            ProxySelector selector = ProxySelector.getDefault();
            List<Proxy> proxyList = selector.select(new URI(serviceURL));
            for (Proxy proxy : proxyList) {
                if (Proxy.Type.HTTP != proxy.type()) continue;
                return (InetSocketAddress)proxy.address();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private HttpInvokerUtils() {
    }

    static {
        sf = HttpInvokerUtils.initializeSSLConnectionFactory();
    }
}

