/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.remoting.rmi.CodebaseAwareObjectInputStream;

public class WhiteAndBlackListCodebaseAwareObjectInputStream
extends CodebaseAwareObjectInputStream {
    public static final String WHITE_LIST = "allowed-api-parameter-classes";
    public static final String BLACK_LIST = "disallowed-api-parameter-classes";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, WhiteAndBlackListCodebaseAwareObjectInputStream.class);
    private static final Patterns whiteListPatterns = new Patterns();
    private static final Patterns blackListPatterns = new Patterns();

    private static void addToWhiteListPatterns(String regex) {
        whiteListPatterns.addPattern(regex);
    }

    private static void addToBlackListPatterns(String regex) {
        blackListPatterns.addPattern(regex);
    }

    public static void populateWhiteAndBlackListOfApiParameterClasses(Properties properties) {
        boolean patternsAdded = false;
        for (String pattern : PropertyUtils.getList((Properties)properties, (String)WHITE_LIST)) {
            patternsAdded = true;
            WhiteAndBlackListCodebaseAwareObjectInputStream.addToWhiteListPatterns(pattern);
        }
        for (String pattern : PropertyUtils.getList((Properties)properties, (String)BLACK_LIST)) {
            patternsAdded = true;
            WhiteAndBlackListCodebaseAwareObjectInputStream.addToBlackListPatterns(pattern);
        }
        if (patternsAdded) {
            WhiteAndBlackListCodebaseAwareObjectInputStream.logPatterns();
        }
    }

    public static void logPatterns() {
        operationLog.info((Object)("Allowed API parameter classes: " + whiteListPatterns));
        operationLog.info((Object)("Disallowed API parameter classes: " + blackListPatterns));
    }

    public WhiteAndBlackListCodebaseAwareObjectInputStream(InputStream in, ClassLoader classLoader, boolean acceptProxyClasses) throws IOException {
        super(in, classLoader, acceptProxyClasses);
    }

    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String className = classDesc.getName();
        this.assertMatchingClassName(className);
        return super.resolveClass(classDesc);
    }

    private void assertMatchingClassName(String className) throws ClassNotFoundException {
        if (className.startsWith("[L") && className.endsWith(";")) {
            this.assertMatchingClassName(className.substring(2, className.length() - 1));
        } else if (!whiteListPatterns.matches(className) || blackListPatterns.matches(className)) {
            operationLog.error((Object)("Attempt to load class " + className));
            throw new IllegalArgumentException("Class not allowed to load: " + className);
        }
    }

    static {
        whiteListPatterns.addPattern("char");
        whiteListPatterns.addPattern("\\[C");
        whiteListPatterns.addPattern("byte");
        whiteListPatterns.addPattern("\\[B");
        whiteListPatterns.addPattern("short");
        whiteListPatterns.addPattern("\\[S");
        whiteListPatterns.addPattern("int");
        whiteListPatterns.addPattern("\\[I");
        whiteListPatterns.addPattern("long");
        whiteListPatterns.addPattern("\\[J");
        whiteListPatterns.addPattern("float");
        whiteListPatterns.addPattern("\\[F");
        whiteListPatterns.addPattern("double");
        whiteListPatterns.addPattern("\\[D");
        whiteListPatterns.addPattern("boolean");
        whiteListPatterns.addPattern("\\[Z");
        whiteListPatterns.addPattern("org\\.springframework\\.remoting\\.support\\.RemoteInvocation");
        whiteListPatterns.addPattern("com\\.marathon\\.util\\.spring\\.StreamSupportingRemoteInvocation");
        whiteListPatterns.addPattern("com\\.marathon\\.util\\.spring\\.RemoteInvocationDecorator");
        whiteListPatterns.addPattern("java\\..*");
        whiteListPatterns.addPattern("org\\.python\\.core\\..*");
        whiteListPatterns.addPattern("org\\.python27\\.core\\..*");
        whiteListPatterns.addPattern("ch\\.ethz\\.sis\\..*");
        whiteListPatterns.addPattern("ch\\.systemsx\\.cisd\\..*");
        whiteListPatterns.addPattern("ch\\.systemsx\\.sybit\\.imageviewer\\..*");
        blackListPatterns.addPattern("org\\.apache\\.commons\\.collections\\.functors\\.InvokerTransformer");
        blackListPatterns.addPattern("org\\.python\\.core\\.PyClass.*");
        blackListPatterns.addPattern("org\\.python27\\.core\\.PyClass.*");
        WhiteAndBlackListCodebaseAwareObjectInputStream.logPatterns();
    }

    private static final class Patterns {
        private final Set<String> patternsAsStrings = new TreeSet<String>();
        private final List<Pattern> patterns = new LinkedList<Pattern>();

        private Patterns() {
        }

        synchronized void addPattern(String pattern) {
            if (!this.patternsAsStrings.contains(pattern)) {
                this.patterns.add(Pattern.compile(pattern));
                this.patternsAsStrings.add(pattern);
            }
        }

        synchronized boolean matches(String string) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.patternsAsStrings.toString();
        }
    }
}

