/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PersistentKeyValueStore {
    private String keyStorePath;
    private ConcurrentMap<String, Serializable> keyStore = new ConcurrentHashMap<String, Serializable>();

    public PersistentKeyValueStore(String keyStorePath) throws IOException, ClassNotFoundException {
        this.keyStorePath = keyStorePath;
        this.load();
    }

    public synchronized void put(String key, Serializable value) throws IOException {
        this.keyStore.put(key, value);
        this.save();
    }

    public synchronized Serializable get(String key) {
        return (Serializable)this.keyStore.get(key);
    }

    public synchronized void remove(String key) throws IOException {
        this.keyStore.remove(key);
        this.save();
    }

    public synchronized boolean containsKey(String key) {
        return this.keyStore.containsKey(key);
    }

    private void save() throws IOException {
        File file = new File(this.keyStorePath);
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fos = new FileOutputStream(this.keyStorePath);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.keyStore);
        oos.close();
    }

    private void load() throws IOException, ClassNotFoundException {
        if (new File(this.keyStorePath).exists()) {
            FileInputStream fis = new FileInputStream(this.keyStorePath);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.keyStore = (ConcurrentMap)ois.readObject();
            ois.close();
        }
    }
}

