/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.gui.ContrastBrightnessPlot;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import ch.systemsx.sybit.imageviewer.processors.ContrastBrightnessProcessor;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ContrastBrightness
extends JPanel
implements ActionListener,
AdjustmentListener,
MouseListener,
Runnable {
    private static final long serialVersionUID = 1L;
    private ImageViewer imageViewer;
    private JScrollBar brightnessSlider;
    private JScrollBar contrastSlider;
    private int sliderRange = 256;
    private JButton resetButton;
    private JButton autoButton;
    private JLabel brightnessSliderLabel;
    private JLabel contrastSliderLabel;
    private ContrastBrightnessPlot plot = new ContrastBrightnessPlot();
    private Thread thread;
    private int brightnessValue = -1;
    private int contrastValue = -1;
    private boolean doAutoAdjust;
    private boolean doReset;
    private int ALL_CHANNELS;
    private int channels = this.ALL_CHANNELS = 3;
    private int contrast;
    private int brightness;
    private final int RESET = 0;
    private final int AUTO = 1;
    private final int APPLY = 2;
    private final int BRIGHTNESS = 3;
    private final int CONTRAST = 4;
    private boolean balance;
    private List<String> channelLabels;
    private JComboBox colorsCombobox;
    private ImageViewerParameters imageViewerParameters;
    private ContrastBrightnessProcessor contrastBrightnessProcessor;
    private boolean[] modifiedChannels;
    private boolean done;

    public ContrastBrightness(ImageViewer imageViewer, boolean balance) {
        this.setPreferredSize(new Dimension(300, 100));
        this.setLayout(new BorderLayout());
        this.balance = balance;
        this.imageViewer = imageViewer;
        this.imageViewerParameters = imageViewer.getImageViewerParameters();
        this.contrastBrightnessProcessor = new ContrastBrightnessProcessor(imageViewer.getImageHandler().getImage().getType(), balance, this.imageViewerParameters);
        this.contrastBrightnessProcessor.setMin(this.imageViewerParameters.getMin(), this.channels);
        this.contrastBrightnessProcessor.setMax(this.imageViewerParameters.getMax(), this.channels);
        if (this.imageViewerParameters.getMinMaxInChannels() != null) {
            this.contrastBrightnessProcessor.setMinMaxInChannels(this.imageViewerParameters.getMinMaxInChannels());
        }
        if (balance) {
            this.channels = 0;
        }
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BoxLayout(internalPanel, 1));
        internalPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        JPanel plotWrapperPanel = new JPanel(new FlowLayout(1));
        plotWrapperPanel.add(this.plot);
        internalPanel.add(plotWrapperPanel);
        internalPanel.add(Box.createVerticalStrut(20));
        this.brightnessSlider = new JScrollBar(0, 0, 1, -this.sliderRange / 2, this.sliderRange / 2);
        this.brightnessSlider.addMouseListener(this);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        Component[] components = this.brightnessSlider.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JButton)) continue;
            JButton arrowButton = (JButton)components[i];
            arrowButton.setActionCommand("brightnessSlider");
            arrowButton.addActionListener(this);
        }
        internalPanel.add(this.brightnessSlider);
        JPanel brightnessSliderPanel = new JPanel(new FlowLayout(1));
        this.brightnessSliderLabel = new JLabel("Brightness");
        brightnessSliderPanel.add(this.brightnessSliderLabel);
        internalPanel.add(brightnessSliderPanel);
        if (!balance) {
            this.contrastSlider = new JScrollBar(0, 0, 1, -this.sliderRange / 2, this.sliderRange / 2);
            this.contrastSlider.addMouseListener(this);
            this.contrastSlider.addAdjustmentListener(this);
            this.contrastSlider.setUnitIncrement(1);
            components = this.contrastSlider.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof JButton)) continue;
                JButton arrowButton = (JButton)components[i];
                arrowButton.setActionCommand("contrastSlider");
                arrowButton.addActionListener(this);
            }
            internalPanel.add(this.contrastSlider);
            JPanel contrastSliderPanel = new JPanel(new FlowLayout(1));
            this.contrastSliderLabel = new JLabel("Contrast");
            contrastSliderPanel.add(this.contrastSliderLabel);
            internalPanel.add(contrastSliderPanel);
        }
        if (balance) {
            this.channelLabels = new ArrayList<String>();
            this.channelLabels.add("Channel Red");
            this.channelLabels.add("Channel Green");
            this.channelLabels.add("Channel Blue");
            this.colorsCombobox = new JComboBox<Object>(this.channelLabels.toArray());
            this.colorsCombobox.setSelectedIndex(0);
            this.colorsCombobox.addActionListener(this);
            JPanel colorsPanel = new JPanel(new BorderLayout());
            colorsPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
            colorsPanel.add((Component)this.colorsCombobox, "North");
            internalPanel.add(colorsPanel);
        }
        JPanel wrappingPanel = new JPanel(new FlowLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        buttonPanel.add(this.resetButton);
        this.autoButton = new JButton("Auto");
        this.autoButton.addActionListener(this);
        if (!balance) {
            buttonPanel.add(this.autoButton);
        }
        wrappingPanel.add(buttonPanel);
        internalPanel.add(wrappingPanel);
        this.add((Component)internalPanel, "North");
        this.thread = new Thread((Runnable)this, "ContrastBrightness");
        this.thread.start();
        this.setupNewImage(imageViewer.getImageHandler().getImage());
        this.updatePlot();
        this.updateLabels(imageViewer.getImageHandler().getImage());
        this.modifiedChannels = new boolean[4];
    }

    private void setupNewImage(ImagePlus imp) {
        this.plot.setDefaultMin(this.contrastBrightnessProcessor.getDefaultMin());
        this.plot.setDefaultMax(this.contrastBrightnessProcessor.getDefaultMax());
        this.updateScrollBars(null, false);
        if (!this.doReset) {
            this.plotHistogram(imp);
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == null) {
                return;
            }
            if (e.getSource() == this.resetButton) {
                this.doReset = true;
                this.notify();
            } else if (e.getSource() == this.autoButton) {
                this.doAutoAdjust = true;
                this.notify();
            } else if (e.getSource() == this.colorsCombobox) {
                this.channels = this.colorsCombobox.getSelectedIndex();
                this.updateScrollBars(null, false);
                this.updateLabels(this.imageViewer.getImageHandler().getImage());
                this.plotHistogram(this.imageViewer.getImageHandler().getImage());
                this.updatePlot();
                this.notify();
            } else if (e.getActionCommand().equals("contrastSlider") && !this.contrastSlider.hasFocus()) {
                this.contrastSlider.requestFocus();
                this.contrastValue = this.contrastSlider.getValue() + this.sliderRange / 2;
                this.notify();
            } else if (e.getActionCommand().equals("brightnessSlider") && !this.brightnessSlider.hasFocus()) {
                this.brightnessSlider.requestFocus();
                this.brightnessValue = this.brightnessSlider.getValue() + this.sliderRange / 2;
                this.notify();
            }
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during processing image", t, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ContrastBrightness contrastBrightness = this;
            synchronized (contrastBrightness) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    private void doUpdate() {
        try {
            if (this.imageViewer.getImageHandler() != null) {
                int action;
                ImagePlus imp = this.imageViewer.getImageHandler().getImage();
                int bvalue = this.brightnessValue;
                int cvalue = this.contrastValue;
                if (this.doReset) {
                    action = 0;
                } else if (this.doAutoAdjust) {
                    action = 1;
                } else if (this.contrastValue >= 0) {
                    action = 4;
                } else if (this.brightnessValue >= 0) {
                    action = 3;
                } else {
                    return;
                }
                this.contrastValue = -1;
                this.brightnessValue = -1;
                this.doAutoAdjust = false;
                this.doReset = false;
                ImageProcessor ip = imp.getProcessor();
                switch (action) {
                    case 0: {
                        this.reset(imp, ip);
                        break;
                    }
                    case 1: {
                        this.autoAdjust(imp, ip);
                        this.cleanChannelsMinMax();
                        break;
                    }
                    case 3: {
                        this.adjustBrightness(imp, ip, bvalue);
                        this.cleanChannelsMinMax();
                        break;
                    }
                    case 4: {
                        this.adjustContrast(imp, ip, cvalue);
                        this.cleanChannelsMinMax();
                    }
                }
                if (action != 2) {
                    this.modifiedChannels[this.channels] = true;
                }
                this.updatePlot();
                this.updateLabels(imp);
                if (this.contrastBrightnessProcessor.isRGBImage()) {
                    imp.unlock();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            ContrastBrightness.this.imageViewer.updateImage();
                        }
                        catch (Throwable t) {
                            ContrastBrightness.this.imageViewer.showErrorDialog("Error during image updating", t, true);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during loading image", t, true);
        }
    }

    private boolean cleanChannelsMinMax() {
        if (this.channels == this.ALL_CHANNELS && this.imageViewer.getImageHandler().getImage().getType() == 4) {
            for (int i = 0; i < this.ALL_CHANNELS; ++i) {
                if (!this.contrastBrightnessProcessor.getMinMaxInChannels().containsKey(i)) continue;
                this.contrastBrightnessProcessor.getMinMaxInChannels().remove(i);
            }
            return true;
        }
        return false;
    }

    private void adjustBrightness(ImagePlus imp, ImageProcessor ip, double bvalue) {
        double center = this.contrastBrightnessProcessor.getDefaultMin() + (this.contrastBrightnessProcessor.getDefaultMax() - this.contrastBrightnessProcessor.getDefaultMin()) * (((double)this.sliderRange - bvalue) / (double)this.sliderRange);
        double width = this.contrastBrightnessProcessor.getMax(this.channels) - this.contrastBrightnessProcessor.getMin(this.channels);
        this.contrastBrightnessProcessor.setMin(center - width / 2.0, this.channels);
        this.contrastBrightnessProcessor.setMax(center + width / 2.0, this.channels);
        this.contrastBrightnessProcessor.setMinAndMax(imp, this.contrastBrightnessProcessor.getMin(this.channels), this.contrastBrightnessProcessor.getMax(this.channels), this.channels);
        if (this.contrastBrightnessProcessor.getMin(this.channels) == this.contrastBrightnessProcessor.getMax(this.channels)) {
            this.contrastBrightnessProcessor.setThreshold(imp);
        }
        if (this.contrastBrightnessProcessor.isRGBImage()) {
            this.contrastBrightnessProcessor.doMasking(imp);
        }
        this.updateScrollBars(this.brightnessSlider, false);
    }

    private void adjustContrast(ImagePlus imp, ImageProcessor ip, int cvalue) {
        double center = this.contrastBrightnessProcessor.getMin(this.channels) + (this.contrastBrightnessProcessor.getMax(this.channels) - this.contrastBrightnessProcessor.getMin(this.channels)) / 2.0;
        double range = this.contrastBrightnessProcessor.getDefaultMax() - this.contrastBrightnessProcessor.getDefaultMin();
        double mid = this.sliderRange / 2;
        double slope = (double)cvalue <= mid ? (double)cvalue / mid : mid / (double)(this.sliderRange - cvalue);
        if (slope > 0.0) {
            this.contrastBrightnessProcessor.setMin(center - 0.5 * range / slope, this.channels);
            this.contrastBrightnessProcessor.setMax(center + 0.5 * range / slope, this.channels);
        } else if (slope == 0.0) {
            this.contrastBrightnessProcessor.setMin(center - 0.5 * range / 0.001, this.channels);
            this.contrastBrightnessProcessor.setMax(center + 0.5 * range / 0.001, this.channels);
        }
        this.contrastBrightnessProcessor.setMinAndMax(imp, this.contrastBrightnessProcessor.getMin(this.channels), this.contrastBrightnessProcessor.getMax(this.channels), this.channels);
        if (this.contrastBrightnessProcessor.isRGBImage()) {
            this.contrastBrightnessProcessor.doMasking(imp);
        }
        this.updateScrollBars(this.contrastSlider, false);
    }

    private void updateScrollBars(final JScrollBar scrollBar, final boolean newRange) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (scrollBar == null || scrollBar != ContrastBrightness.this.contrastSlider) {
                        double mid = ContrastBrightness.this.sliderRange / 2;
                        double c = (ContrastBrightness.this.contrastBrightnessProcessor.getDefaultMax() - ContrastBrightness.this.contrastBrightnessProcessor.getDefaultMin()) / (ContrastBrightness.this.contrastBrightnessProcessor.getMax(ContrastBrightness.this.channels) - ContrastBrightness.this.contrastBrightnessProcessor.getMin(ContrastBrightness.this.channels)) * mid;
                        if (c > mid) {
                            c = (double)ContrastBrightness.this.sliderRange - (ContrastBrightness.this.contrastBrightnessProcessor.getMax(ContrastBrightness.this.channels) - ContrastBrightness.this.contrastBrightnessProcessor.getMin(ContrastBrightness.this.channels)) / (ContrastBrightness.this.contrastBrightnessProcessor.getDefaultMax() - ContrastBrightness.this.contrastBrightnessProcessor.getDefaultMin()) * mid;
                        }
                        ContrastBrightness.this.contrast = (int)c - ContrastBrightness.this.sliderRange / 2;
                        if (ContrastBrightness.this.contrastSlider != null) {
                            if (newRange) {
                                ContrastBrightness.this.contrastSlider.setValues(ContrastBrightness.this.contrast, 1, 0, ContrastBrightness.this.sliderRange);
                            } else {
                                ContrastBrightness.this.contrastSlider.setValue(ContrastBrightness.this.contrast);
                            }
                        }
                    }
                    if (scrollBar == null || scrollBar != ContrastBrightness.this.brightnessSlider) {
                        double level = ContrastBrightness.this.contrastBrightnessProcessor.getMin(ContrastBrightness.this.channels) + (ContrastBrightness.this.contrastBrightnessProcessor.getMax(ContrastBrightness.this.channels) - ContrastBrightness.this.contrastBrightnessProcessor.getMin(ContrastBrightness.this.channels)) / 2.0;
                        double normalizedLevel = 1.0 - (level - ContrastBrightness.this.contrastBrightnessProcessor.getDefaultMin()) / (ContrastBrightness.this.contrastBrightnessProcessor.getDefaultMax() - ContrastBrightness.this.contrastBrightnessProcessor.getDefaultMin());
                        ContrastBrightness.this.brightness = (int)(normalizedLevel * (double)ContrastBrightness.this.sliderRange) - ContrastBrightness.this.sliderRange / 2;
                        if (newRange) {
                            ContrastBrightness.this.brightnessSlider.setValues(ContrastBrightness.this.brightness, 1, 0, ContrastBrightness.this.sliderRange);
                        } else {
                            ContrastBrightness.this.brightnessSlider.setValue(ContrastBrightness.this.brightness);
                        }
                    }
                }
                catch (Throwable t) {
                    ContrastBrightness.this.imageViewer.showErrorDialog("Error during updating scrollbars", t, true);
                }
            }
        });
    }

    private void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        this.contrastBrightnessProcessor.reset(imp, this.channels);
        this.contrastBrightnessProcessor.autoAdjust(imp, this.channels);
        this.updateScrollBars(null, false);
    }

    private void reset(ImagePlus imp, ImageProcessor ip) {
        this.contrastBrightnessProcessor.reset(imp, this.channels);
        this.updateScrollBars(null, false);
        if (!this.cleanChannelsMinMax() && this.imageViewer.getImageHandler().getImage().getType() == 4 && this.contrastBrightnessProcessor.getMinMaxInChannels().containsKey(this.channels)) {
            this.contrastBrightnessProcessor.getMinMaxInChannels().remove(this.channels);
        }
    }

    public void plotHistogram(ImagePlus imp) {
        ImageStatistics stats;
        if (this.balance && (this.channels == 0 || this.channels == 1 || this.channels == 2) && imp.getType() == 4) {
            int[] pixels = (int[])((ColorProcessor)imp.getProcessor()).getSnapshotPixels();
            byte[] bytePixels = new byte[imp.getWidth() * imp.getHeight()];
            for (int i = 0; i < pixels.length; ++i) {
                if (this.channels == 0) {
                    bytePixels[i] = (byte)((pixels[i] & 0xFF0000) >> 16);
                    continue;
                }
                if (this.channels == 1) {
                    bytePixels[i] = (byte)((pixels[i] & 0xFF00) >> 8);
                    continue;
                }
                if (this.channels != 2) continue;
                bytePixels[i] = (byte)(pixels[i] & 0xFF);
            }
            ByteProcessor ip = new ByteProcessor(imp.getWidth(), imp.getHeight(), bytePixels, null);
            stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)0, (Calibration)imp.getCalibration());
        } else {
            stats = this.imageViewer.getOriginalImageStatistics();
        }
        Color color = Color.gray;
        if (imp.isComposite()) {
            color = ((CompositeImage)imp).getChannelColor();
        }
        this.plot.setHistogram(stats, color);
    }

    private void updatePlot() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    ContrastBrightness.this.plot.setMin(ContrastBrightness.this.contrastBrightnessProcessor.getMin(ContrastBrightness.this.channels));
                    ContrastBrightness.this.plot.setMax(ContrastBrightness.this.contrastBrightnessProcessor.getMax(ContrastBrightness.this.channels));
                    ContrastBrightness.this.plot.repaint();
                }
                catch (Throwable t) {
                    ContrastBrightness.this.imageViewer.showErrorDialog("Error during drawing the plot", t, true);
                }
            }
        });
    }

    private void updateLabels(ImagePlus imp) {
        Calibration calibration = imp.getCalibration();
        if (calibration.calibrated()) {
            this.contrastBrightnessProcessor.setMin(calibration.getCValue(this.contrastBrightnessProcessor.getMin(this.channels)), this.channels);
            this.contrastBrightnessProcessor.setMax(calibration.getCValue(this.contrastBrightnessProcessor.getMax(this.channels)), this.channels);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    ContrastBrightness.this.brightnessSliderLabel.setText("Brightness: " + ContrastBrightness.this.brightnessSlider.getValue());
                    if (ContrastBrightness.this.contrastSliderLabel != null) {
                        ContrastBrightness.this.contrastSliderLabel.setText("Contrast: " + ContrastBrightness.this.contrastSlider.getValue());
                    }
                }
                catch (Throwable t) {
                    ContrastBrightness.this.imageViewer.showErrorDialog("Error during updating the labels", t, true);
                }
            }
        });
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        if (source == this.contrastSlider && this.contrastSlider.hasFocus()) {
            this.contrastValue = this.contrastSlider.getValue() + this.sliderRange / 2;
        } else if (source == this.brightnessSlider && this.brightnessSlider.hasFocus()) {
            this.brightnessValue = this.brightnessSlider.getValue() + this.sliderRange / 2;
        }
        this.notify();
    }

    public synchronized void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public synchronized void mousePressed(MouseEvent e) {
        if (e.getSource() == this.contrastSlider) {
            this.contrastSlider.requestFocus();
        } else if (e.getSource() == this.brightnessSlider) {
            this.brightnessSlider.requestFocus();
        }
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void finish() {
        this.done = true;
        if (this.thread != null && this.thread.isAlive() && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
    }

    public ContrastBrightnessProcessor getContrastBrightnessProcessor() {
        return this.contrastBrightnessProcessor;
    }
}

