/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.HttpStatusCodeProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum DefaultHttpStatusCodeProvider implements HttpStatusCodeProvider
{
    INSTANCE;

    final Map<Integer, ErrorResolver.JsonError> httpStatus2JsonError = new HashMap<Integer, ErrorResolver.JsonError>();

    private DefaultHttpStatusCodeProvider() {
        this.httpStatus2JsonError.put(500, ErrorResolver.JsonError.INTERNAL_ERROR);
        this.httpStatus2JsonError.put(404, ErrorResolver.JsonError.METHOD_NOT_FOUND);
        this.httpStatus2JsonError.put(400, ErrorResolver.JsonError.PARSE_ERROR);
    }

    @Override
    public int getHttpStatusCode(int resultCode) {
        if (resultCode == 0) {
            return 200;
        }
        if (this.isErrorCode(resultCode)) {
            return 500;
        }
        if (resultCode == ErrorResolver.JsonError.INVALID_REQUEST.code || resultCode == ErrorResolver.JsonError.PARSE_ERROR.code) {
            return 400;
        }
        if (resultCode == ErrorResolver.JsonError.METHOD_NOT_FOUND.code) {
            return 404;
        }
        return 200;
    }

    private boolean isErrorCode(int result) {
        for (ErrorResolver.JsonError error : Arrays.asList(ErrorResolver.JsonError.INTERNAL_ERROR, ErrorResolver.JsonError.METHOD_PARAMS_INVALID, ErrorResolver.JsonError.ERROR_NOT_HANDLED, ErrorResolver.JsonError.BULK_ERROR)) {
            if (error.code != result) continue;
            return true;
        }
        return -32000 >= result && result >= -32099;
    }

    @Override
    public Integer getJsonRpcCode(int httpStatusCode) {
        return this.httpStatus2JsonError.containsKey(httpStatusCode) ? Integer.valueOf(this.httpStatus2JsonError.get(httpStatusCode).getCode()) : null;
    }
}

