/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.NoCloseInputStream;
import com.googlecode.jsonrpc4j.StreamEndedException;
import java.io.IOException;
import java.io.InputStream;

public class ReadContext {
    private final InputStream input;
    private final ObjectMapper mapper;

    private ReadContext(InputStream input, ObjectMapper mapper) {
        this.input = new NoCloseInputStream(input);
        this.mapper = mapper;
    }

    public static ReadContext getReadContext(InputStream input, ObjectMapper mapper) {
        return new ReadContext(input, mapper);
    }

    public JsonNode nextValue() throws IOException {
        return (JsonNode)this.mapper.readValue(this.input, JsonNode.class);
    }

    public void assertReadable() throws IOException {
        if (this.input.markSupported()) {
            this.input.mark(1);
            if (this.input.read() == -1) {
                throw new StreamEndedException();
            }
            this.input.reset();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.input.hashCode();
        result = 31 * result + (this.mapper == null ? 0 : this.mapper.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadContext other = (ReadContext)obj;
        if (!this.input.equals(other.input)) {
            return false;
        }
        return !(this.mapper == null ? other.mapper != null : !this.mapper.equals(other.mapper));
    }
}

