/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.JsonRpcBasicServer;
import com.googlecode.jsonrpc4j.StreamEndedException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamServer {
    private static final Logger logger = LoggerFactory.getLogger(StreamServer.class);
    private static final long SERVER_SOCKET_SO_TIMEOUT = 5000L;
    private final ThreadPoolExecutor executor;
    private final ServerSocket serverSocket;
    private final JsonRpcBasicServer jsonRpcServer;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicBoolean keepRunning = new AtomicBoolean(false);
    private final Set<Server> servers = new HashSet<Server>();
    private int maxClientErrors = 5;

    private StreamServer(JsonRpcBasicServer jsonRpcServer, int maxThreads, int port, int backlog, InetAddress bindAddress) throws IOException {
        this(jsonRpcServer, maxThreads, ServerSocketFactory.getDefault().createServerSocket(port, backlog, bindAddress));
    }

    public StreamServer(JsonRpcBasicServer jsonRpcServer, int maxThreads, ServerSocket serverSocket) {
        this.jsonRpcServer = jsonRpcServer;
        this.serverSocket = serverSocket;
        this.executor = new ThreadPoolExecutor(maxThreads + 1, maxThreads + 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        jsonRpcServer.setRethrowExceptions(false);
    }

    public Set<Server> getServers() {
        return Collections.unmodifiableSet(this.servers);
    }

    public void start() {
        if (this.tryToStart()) {
            throw new IllegalStateException("The StreamServer is already started");
        }
        logger.debug("StreamServer starting {}:{}", (Object)this.serverSocket.getInetAddress(), (Object)this.serverSocket.getLocalPort());
        this.keepRunning.set(true);
        this.executor.submit(new Server());
    }

    private boolean tryToStart() {
        return !this.isStarted.compareAndSet(false, true);
    }

    public void stop() throws InterruptedException {
        if (!this.isStarted.get()) {
            throw new IllegalStateException("The StreamServer is not started");
        }
        this.stopServer();
        this.stopClients();
        this.closeSocket();
        try {
            this.waitForServerToTerminate();
            this.isStarted.set(false);
            this.stopServer();
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException while waiting for termination", (Throwable)e);
            throw e;
        }
    }

    private void stopServer() {
        this.keepRunning.set(false);
    }

    private void stopClients() {
        this.executor.shutdownNow();
    }

    private void closeSocket() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            logger.debug("Failed to close socket", (Throwable)e);
        }
    }

    private void waitForServerToTerminate() throws InterruptedException {
        if (!this.executor.isTerminated()) {
            this.executor.awaitTermination(7000L, TimeUnit.MILLISECONDS);
        }
    }

    private void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable t) {
                logger.warn("Error closing, ignoring", t);
            }
        }
    }

    public int getNumberOfConnections() {
        return this.servers.size();
    }

    public int getMaxClientErrors() {
        return this.maxClientErrors;
    }

    public void setMaxClientErrors(int maxClientErrors) {
        this.maxClientErrors = maxClientErrors;
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public class Server
    implements Runnable {
        private int errors;
        private Throwable lastException;

        public int getNumberOfErrors() {
            return this.errors;
        }

        public Throwable getLastException() {
            return this.lastException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket serverSocket = StreamServer.this.serverSocket;
            Socket clientSocket = null;
            while (StreamServer.this.keepRunning.get()) {
                try {
                    serverSocket.setSoTimeout(5000);
                    clientSocket = serverSocket.accept();
                    logger.debug("Client connected: {}:{}", (Object)clientSocket.getInetAddress().getHostAddress(), (Object)clientSocket.getPort());
                    StreamServer.this.executor.submit(new Server());
                    break;
                }
                catch (SocketTimeoutException e) {
                    this.handleSocketTimeoutException(e);
                }
                catch (SSLException sslException) {
                    logger.error("SSLException while listening for clients, terminating", (Throwable)sslException);
                    break;
                }
                catch (IOException ioe) {
                    if (SocketException.class.isInstance(ioe) && !StreamServer.this.keepRunning.get()) break;
                    logger.error("Exception while listening for clients", (Throwable)ioe);
                }
            }
            if (clientSocket != null) {
                OutputStream output;
                BufferedInputStream input;
                try {
                    input = new BufferedInputStream(clientSocket.getInputStream());
                    output = clientSocket.getOutputStream();
                }
                catch (IOException e) {
                    logger.error("Client socket failed", (Throwable)e);
                    return;
                }
                StreamServer.this.servers.add(this);
                try {
                    while (StreamServer.this.keepRunning.get()) {
                        try {
                            StreamServer.this.jsonRpcServer.handleRequest(input, output);
                        }
                        catch (Throwable t) {
                            if (StreamEndedException.class.isInstance(t)) {
                                logger.debug("Client disconnected: {}:{}", (Object)clientSocket.getInetAddress().getHostAddress(), (Object)clientSocket.getPort());
                            } else {
                                ++this.errors;
                                this.lastException = t;
                                if (this.errors < StreamServer.this.maxClientErrors) {
                                    logger.error("Exception while handling request", t);
                                    continue;
                                }
                                logger.error("Closing client connection due to repeated errors", t);
                            }
                            break;
                        }
                    }
                }
                finally {
                    StreamServer.this.servers.remove(this);
                    StreamServer.this.closeQuietly(clientSocket);
                    StreamServer.this.closeQuietly(input);
                    StreamServer.this.closeQuietly(output);
                }
            }
        }

        private void handleSocketTimeoutException(SocketTimeoutException e) {
        }
    }
}

