/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.StringUtils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFHelper;
import hdf.hdf5lib.HDF5Constants;
import java.lang.reflect.Field;

class HDF5CompoundMemberByteifyerStringFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerStringFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            HDF5DataClass dataClass = memberInfoOrNull.getType().getDataClass();
            return !(clazz != String.class && clazz != char[].class || dataClass != HDF5DataClass.STRING && dataClass != HDF5DataClass.REFERENCE);
        }
        return clazz == String.class || clazz == char[].class;
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType enumTypeOrNull, Class<?> memberClazz, int index, int offset, int memOffset, HDF5ValueObjectByteifyer.IFileAccessProvider fileAccessProvider) {
        int size;
        String memberName = member.getMemberName();
        int maxCharacters = member.getMemberTypeLength();
        boolean isVariableLengthType = member.isVariableLength() || maxCharacters == 0 && member.tryGetHints() != null && member.tryGetHints().isUseVariableLengthStrings();
        boolean isReferenceType = member.isReference();
        long memberTypeId = isVariableLengthType ? fileAccessProvider.getVariableLengthStringDataTypeId() : member.getStorageDataTypeId();
        CharacterEncoding encoding = isReferenceType ? CharacterEncoding.ASCII : fileAccessProvider.getCharacterEncoding(memberTypeId);
        int n = size = compoundMemberInfoOrNull != null ? compoundMemberInfoOrNull.getType().getSize() : encoding.getMaxBytesPerChar() * maxCharacters;
        long stringOrRefDataTypeId = memberTypeId < 0L ? (isReferenceType ? HDF5Constants.H5T_STD_REF_OBJ : fileAccessProvider.getStringDataTypeId(size)) : memberTypeId;
        boolean isCharArray = memberClazz == char[].class;
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, fileAccessProvider, offset, memOffset, stringOrRefDataTypeId, maxCharacters, size, encoding, isCharArray, isVariableLengthType, isReferenceType);
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, fileAccessProvider, offset, memOffset, stringOrRefDataTypeId, maxCharacters, size, encoding, isCharArray, isVariableLengthType, isReferenceType);
            }
            case LIST: {
                return this.createByteifyerForList(memberName, fileAccessProvider, index, offset, memOffset, stringOrRefDataTypeId, maxCharacters, size, encoding, isCharArray, isVariableLengthType, isReferenceType);
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, fileAccessProvider, index, offset, memOffset, stringOrRefDataTypeId, maxCharacters, size, encoding, isCharArray, isVariableLengthType, isReferenceType);
            }
        }
        throw new Error("Unknown access type");
    }

    private static String refToStr(byte[] byteArr, int offset) {
        long reference = NativeData.byteToLong(byteArr, NativeData.ByteOrder.NATIVE, offset, 1)[0];
        return String.valueOf('\u0000') + Long.toString(reference);
    }

    static String bytesToString(byte[] byteArr, int totalOffset, int maxIdx, CharacterEncoding encoding, boolean isVariableLengthType, boolean isReferenceType) {
        String s = isVariableLengthType ? HDFHelper.createVLStrFromCompound(byteArr, totalOffset) : (isReferenceType ? HDF5CompoundMemberByteifyerStringFactory.refToStr(byteArr, totalOffset) : StringUtils.fromBytes0Term(byteArr, totalOffset, maxIdx, encoding));
        return s;
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, final HDF5ValueObjectByteifyer.IFileAccessProvider fileAccessProvider, int offset, int memOffset, final long stringOrRefDataTypeId, int maxCharacters, int size, CharacterEncoding encoding, final boolean isCharArray, final boolean isVariableLengthType, final boolean isReferenceType) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5StringMemberByteifyer(field, memberName, size, offset, memOffset, encoding, maxCharacters, isVariableLengthType, isReferenceType){

            @Override
            protected long getMemberStorageTypeId() {
                return stringOrRefDataTypeId;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                String s;
                Object o = field.get(obj);
                if (o == null) {
                    throw new NullPointerException("Field '" + field.getName() + "' is null");
                }
                String string = s = isCharArray ? new String((char[])o) : o.toString();
                if (isVariableLengthType) {
                    byte[] result = new byte[HDFHelper.getMachineWordSize()];
                    HDFHelper.compoundCpyVLStr(s, result, 0);
                    return result;
                }
                if (isReferenceType) {
                    return fileAccessProvider.createObjectReference(s);
                }
                return StringUtils.toBytes0Term(s, this.getMaxCharacters(), this.encoding);
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offsetInMemory;
                int maxIdx = totalOffset + this.maxCharacters;
                String s = HDF5CompoundMemberByteifyerStringFactory.bytesToString(byteArr, totalOffset, maxIdx, this.encoding, isVariableLengthType, isReferenceType);
                field.set(obj, isCharArray ? (Object)s.toCharArray() : s);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, final HDF5ValueObjectByteifyer.IFileAccessProvider fileAccessProvider, int offset, int memOffset, final long stringOrRefDataTypeId, int maxCharacters, int size, CharacterEncoding encoding, final boolean isCharArray, final boolean isVariableLengthType, final boolean isReferenceType) {
        return new HDF5StringMemberByteifyer(null, memberName, size, offset, memOffset, encoding, maxCharacters, isVariableLengthType, isReferenceType){

            @Override
            protected long getMemberStorageTypeId() {
                return stringOrRefDataTypeId;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object o = HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                String s = o.getClass() == char[].class ? new String((char[])o) : o.toString();
                if (isVariableLengthType) {
                    byte[] result = new byte[HDFHelper.getMachineWordSize()];
                    HDFHelper.compoundCpyVLStr(s, result, 0);
                    return result;
                }
                if (isReferenceType) {
                    return fileAccessProvider.createObjectReference(s);
                }
                return StringUtils.toBytes0Term(s, this.getMaxCharacters(), this.encoding);
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offsetInMemory;
                int maxIdx = totalOffset + this.maxCharacters;
                String s = HDF5CompoundMemberByteifyerStringFactory.bytesToString(byteArr, totalOffset, maxIdx, this.encoding, isVariableLengthType, isReferenceType);
                if (isCharArray) {
                    HDF5CompoundByteifyerFactory.putMap(obj, memberName, s.toCharArray());
                } else {
                    HDF5CompoundByteifyerFactory.putMap(obj, memberName, s);
                }
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final HDF5ValueObjectByteifyer.IFileAccessProvider fileAccessProvider, final int index, int offset, int memOffset, final long stringOrRefDataTypeId, int maxCharacters, int size, CharacterEncoding encoding, final boolean isCharArray, final boolean isVariableLengthType, final boolean isReferenceType) {
        return new HDF5StringMemberByteifyer(null, memberName, size, offset, memOffset, encoding, maxCharacters, isVariableLengthType, isReferenceType){

            @Override
            protected long getMemberStorageTypeId() {
                return stringOrRefDataTypeId;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object o = HDF5CompoundByteifyerFactory.getList(obj, index);
                String s = o.getClass() == char[].class ? new String((char[])o) : o.toString();
                if (isVariableLengthType) {
                    byte[] result = new byte[HDFHelper.getMachineWordSize()];
                    HDFHelper.compoundCpyVLStr(s, result, 0);
                    return result;
                }
                if (isReferenceType) {
                    return fileAccessProvider.createObjectReference(s);
                }
                return StringUtils.toBytes0Term(s, this.getMaxCharacters(), this.encoding);
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offsetInMemory;
                int maxIdx = totalOffset + this.maxCharacters;
                String s = HDF5CompoundMemberByteifyerStringFactory.bytesToString(byteArr, totalOffset, maxIdx, this.encoding, isVariableLengthType, isReferenceType);
                if (isCharArray) {
                    HDF5CompoundByteifyerFactory.setList(obj, index, s.toCharArray());
                } else {
                    HDF5CompoundByteifyerFactory.setList(obj, index, s);
                }
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final HDF5ValueObjectByteifyer.IFileAccessProvider fileAccessProvider, final int index, int offset, int memOffset, final long stringOrRefDataTypeId, int maxCharacters, int size, CharacterEncoding encoding, final boolean isCharArray, final boolean isVariableLengthType, final boolean isReferenceType) {
        return new HDF5StringMemberByteifyer(null, memberName, size, offset, memOffset, encoding, maxCharacters, isVariableLengthType, isReferenceType){

            @Override
            protected long getMemberStorageTypeId() {
                return stringOrRefDataTypeId;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object o = HDF5CompoundByteifyerFactory.getArray(obj, index);
                String s = o.getClass() == char[].class ? new String((char[])o) : o.toString();
                if (isVariableLengthType) {
                    byte[] result = new byte[HDFHelper.getMachineWordSize()];
                    HDFHelper.compoundCpyVLStr(s, result, 0);
                    return result;
                }
                if (isReferenceType) {
                    return fileAccessProvider.createObjectReference(s);
                }
                return StringUtils.toBytes0Term(s, this.getMaxCharacters(), this.encoding);
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offsetInMemory;
                int maxIdx = totalOffset + this.maxCharacters;
                String s = HDF5CompoundMemberByteifyerStringFactory.bytesToString(byteArr, totalOffset, maxIdx, this.encoding, isVariableLengthType, isReferenceType);
                if (isCharArray) {
                    HDF5CompoundByteifyerFactory.setArray(obj, index, s.toCharArray());
                } else {
                    HDF5CompoundByteifyerFactory.setArray(obj, index, s);
                }
            }
        };
    }

    private static abstract class HDF5StringMemberByteifyer
    extends HDF5MemberByteifyer {
        HDF5StringMemberByteifyer(Field fieldOrNull, String memberName, int size, int offset, int memOffset, CharacterEncoding encoding, int maxCharacters, boolean isVariableLengthType, boolean isReferenceType) {
            super(fieldOrNull, memberName, size, offset, memOffset, encoding, maxCharacters, isVariableLengthType, isReferenceType);
        }

        @Override
        int getElementSize() {
            return this.isVariableLengthType() ? HDFHelper.getMachineWordSize() : 1;
        }

        @Override
        public boolean mayBeCut() {
            return true;
        }

        @Override
        protected long getMemberNativeTypeId() {
            return -1L;
        }
    }
}

