/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.io;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5FactoryProvider;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5OpaqueType;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.exceptions.HDF5FileNotFoundException;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Arrays;

public class HDF5DataSetRandomAccessFile
implements IRandomAccessFile,
Flushable {
    private final IHDF5Reader reader;
    private final IHDF5Writer writerOrNull;
    private final String dataSetPath;
    private final HDF5DataSetInformation dataSetInfo;
    private final HDF5OpaqueType opaqueTypeOrNull;
    private final int blockSize;
    private final boolean extendable;
    private final boolean closeReaderOnCloseFile;
    private long length;
    private int realBlockSize;
    private byte[] block;
    private long blockOffset;
    private int positionInBlock;
    private boolean blockDirty;
    private long blockOffsetMark = -1L;
    private int positionInBlockMark = -1;
    private boolean extensionPending;
    private NativeData.ByteOrder byteOrder = NativeData.ByteOrder.BIG_ENDIAN;

    HDF5DataSetRandomAccessFile(File hdf5File, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int size, String opaqueTagOrNull, boolean readOnly) {
        this(HDF5DataSetRandomAccessFile.createHDF5ReaderOrWriter(hdf5File, readOnly), dataSetPath, creationStorageFeature, size, opaqueTagOrNull, true);
    }

    private static IHDF5Reader createHDF5ReaderOrWriter(File hdf5File, boolean readOnly) {
        try {
            if (readOnly) {
                return HDF5FactoryProvider.get().openForReading(hdf5File);
            }
            return HDF5FactoryProvider.get().open(hdf5File);
        }
        catch (HDF5FileNotFoundException ex) {
            throw new IOExceptionUnchecked(new FileNotFoundException(ex.getMessage()));
        }
        catch (HDF5Exception ex) {
            throw new IOExceptionUnchecked((Throwable)ex);
        }
    }

    HDF5DataSetRandomAccessFile(IHDF5Reader reader, String dataSetPath, HDF5GenericStorageFeatures creationStorageFeature, int size, String opaqueTagOrNull, boolean closeReaderOnCloseFile) throws IOExceptionUnchecked {
        this.closeReaderOnCloseFile = closeReaderOnCloseFile;
        boolean readOnly = !(reader instanceof IHDF5Writer);
        try {
            if (readOnly) {
                this.reader = reader;
                this.writerOrNull = null;
            } else {
                this.writerOrNull = (IHDF5Writer)reader;
                this.writerOrNull.file().addFlushable(this);
                this.reader = this.writerOrNull;
                if (!this.writerOrNull.exists(dataSetPath)) {
                    long maxSize = HDF5DataSetRandomAccessFile.requiresFixedMaxSize(creationStorageFeature) ? size : 0;
                    if (opaqueTagOrNull == null) {
                        this.writerOrNull.int8().createArray(dataSetPath, maxSize, size, HDF5IntStorageFeatures.createFromGeneric(creationStorageFeature));
                    } else {
                        this.writerOrNull.opaque().createArray(dataSetPath, opaqueTagOrNull, maxSize, size, creationStorageFeature);
                    }
                }
            }
        }
        catch (HDF5Exception ex) {
            throw new IOExceptionUnchecked((Throwable)ex);
        }
        this.dataSetPath = dataSetPath;
        this.dataSetInfo = reader.getDataSetInformation(dataSetPath);
        this.opaqueTypeOrNull = !readOnly && this.dataSetInfo.getTypeInformation().getDataClass() == HDF5DataClass.OPAQUE ? reader.opaque().tryGetOpaqueType(dataSetPath) : null;
        if (this.dataSetInfo.getRank() != 1) {
            throw new IOExceptionUnchecked("Dataset has wrong rank (r=" + this.dataSetInfo.getRank() + ")");
        }
        if (this.dataSetInfo.getTypeInformation().getElementSize() != 1) {
            throw new IOExceptionUnchecked("Dataset has wrong element size (size=" + this.dataSetInfo.getTypeInformation().getElementSize() + " bytes)");
        }
        this.length = this.dataSetInfo.getSize();
        if (this.dataSetInfo.getStorageLayout() == HDF5StorageLayout.CHUNKED) {
            this.blockSize = this.dataSetInfo.tryGetChunkSizes()[0];
        } else {
            if ((long)((int)this.length) != this.length()) {
                throw new IOExceptionUnchecked("Dataset is too large (size=" + this.length + " bytes)");
            }
            this.blockSize = (int)this.length;
        }
        this.extendable = this.dataSetInfo.getStorageLayout() == HDF5StorageLayout.CHUNKED;
        this.blockOffset = 0L;
        this.block = new byte[this.blockSize];
        this.realBlockSize = -1;
        this.positionInBlock = 0;
    }

    private static boolean requiresFixedMaxSize(HDF5GenericStorageFeatures features) {
        return features.tryGetProposedLayout() != null && features.tryGetProposedLayout() != HDF5StorageLayout.CHUNKED;
    }

    private void ensureInitalizedForWriting(int lenCurrentOp) throws IOExceptionUnchecked {
        if (this.realBlockSize < 0) {
            this.realBlockSize = this.blockSize;
            long minLen = this.blockOffset + (long)this.realBlockSize;
            long oldLength = this.length();
            if (minLen > oldLength) {
                this.realBlockSize = Math.min(this.realBlockSize, lenCurrentOp);
                minLen = this.blockOffset + (long)this.realBlockSize;
                if (minLen > oldLength) {
                    this.setLength(minLen);
                }
            }
            if (oldLength - (long)this.blockSize > 0L) {
                try {
                    this.realBlockSize = this.reader.opaque().readArrayToBlockWithOffset(this.dataSetPath, this.block, this.realBlockSize, this.blockOffset, 0);
                }
                catch (HDF5Exception ex) {
                    throw new IOExceptionUnchecked((Throwable)ex);
                }
            } else {
                Arrays.fill(this.block, (byte)0);
            }
        }
    }

    private void ensureInitalizedForReading() throws IOExceptionUnchecked {
        if (this.realBlockSize < 0) {
            if (this.eof()) {
                this.realBlockSize = 0;
            } else {
                try {
                    this.realBlockSize = this.reader.opaque().readArrayToBlockWithOffset(this.dataSetPath, this.block, this.blockSize, this.blockOffset, 0);
                }
                catch (HDF5Exception ex) {
                    throw new IOExceptionUnchecked((Throwable)ex);
                }
            }
        }
    }

    private void readBlock(long newBlockOffset) throws IOExceptionUnchecked {
        if (newBlockOffset != this.blockOffset) {
            this.flush();
            try {
                this.realBlockSize = this.reader.opaque().readArrayToBlockWithOffset(this.dataSetPath, this.block, this.blockSize, newBlockOffset, 0);
            }
            catch (HDF5Exception ex) {
                throw new IOExceptionUnchecked((Throwable)ex);
            }
            this.blockOffset = newBlockOffset;
        }
    }

    private void readNextBlockResetPosition() {
        this.readBlock(this.blockOffset + (long)this.realBlockSize);
        this.positionInBlock = 0;
    }

    private boolean eof() {
        return this.available() == 0;
    }

    private void checkEoFOnWrite() {
        if (!this.extendable && this.eof()) {
            throw new IOExceptionUnchecked(new EOFException("Dataset is EOF and not extendable."));
        }
    }

    public File getHdf5File() {
        return this.reader.file().getFile();
    }

    public String getDataSetPath() {
        return this.dataSetPath;
    }

    public boolean isReadOnly() {
        return this.writerOrNull == null;
    }

    private void extend(int numberOfBytesToExtend) throws IOExceptionUnchecked {
        long len = this.length();
        long pos = this.getFilePointer();
        long newLen = pos + (long)numberOfBytesToExtend;
        if (newLen > len) {
            if (!this.extendable) {
                throw new IOExceptionUnchecked("Unable to extend dataset from " + len + " to " + newLen + ": dataset is not extenable.");
            }
            this.setLength(pos + (long)numberOfBytesToExtend);
        }
    }

    private void checkWrite(int lenCurrentOp) throws IOExceptionUnchecked {
        this.ensureInitalizedForWriting(lenCurrentOp);
        this.checkWriteDoNotExtend();
        if (this.extensionPending) {
            this.setLength(this.blockOffset + (long)this.positionInBlock);
        }
    }

    private void checkWriteDoNotExtend() throws IOExceptionUnchecked {
        if (this.isReadOnly()) {
            throw new IOExceptionUnchecked("HDF5 dataset opened in read-only mode.");
        }
    }

    @Override
    public long getFilePointer() throws IOExceptionUnchecked {
        return this.blockOffset + (long)this.positionInBlock;
    }

    @Override
    public int read() throws IOExceptionUnchecked {
        this.ensureInitalizedForReading();
        if (this.positionInBlock == this.realBlockSize) {
            if (this.eof()) {
                return -1;
            }
            this.readNextBlockResetPosition();
            if (this.eof()) {
                return -1;
            }
        }
        return this.block[this.positionInBlock++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOExceptionUnchecked {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOExceptionUnchecked {
        this.ensureInitalizedForReading();
        int realLen = this.getRealLen(len);
        if (realLen == 0) {
            return -1;
        }
        int bytesLeft = realLen;
        int currentOff = off;
        while (bytesLeft > 0) {
            int lenInBlock = Math.min(bytesLeft, this.bytesLeftInBlock());
            System.arraycopy(this.block, this.positionInBlock, b, currentOff, lenInBlock);
            this.positionInBlock += lenInBlock;
            currentOff += lenInBlock;
            if ((bytesLeft -= lenInBlock) <= 0) continue;
            this.readNextBlockResetPosition();
        }
        return realLen;
    }

    private int bytesLeftInBlock() {
        return this.realBlockSize - this.positionInBlock;
    }

    private int getRealLen(int len) {
        return Math.min(len, this.available());
    }

    private long getRealLen(long len) {
        return Math.min(len, (long)this.available());
    }

    @Override
    public long skip(long n) throws IOExceptionUnchecked {
        long realN = this.getRealLen(n);
        this.seek(this.getFilePointer() + realN);
        return realN;
    }

    @Override
    public int available() {
        return (int)Math.min(this.availableLong(), Integer.MAX_VALUE);
    }

    private long availableLong() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public void close() throws IOExceptionUnchecked {
        this.flush();
        if (this.closeReaderOnCloseFile) {
            try {
                this.reader.close();
            }
            catch (HDF5Exception ex) {
                throw new IOExceptionUnchecked((Throwable)ex);
            }
        } else if (this.writerOrNull != null) {
            this.writerOrNull.file().removeFlushable(this);
        }
    }

    @Override
    public void mark(int readlimit) {
        this.blockOffsetMark = this.blockOffset;
        this.positionInBlockMark = this.positionInBlock;
    }

    @Override
    public void reset() throws IOExceptionUnchecked {
        if (this.blockOffsetMark < 0L) {
            throw new IOExceptionUnchecked(new IOException("Stream not marked."));
        }
        this.readBlock(this.blockOffsetMark);
        this.positionInBlock = this.positionInBlockMark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void flush() throws IOExceptionUnchecked {
        if (!this.isReadOnly() && this.blockDirty) {
            try {
                if (this.opaqueTypeOrNull != null) {
                    this.writerOrNull.opaque().writeArrayBlockWithOffset(this.dataSetPath, this.opaqueTypeOrNull, this.block, this.realBlockSize, this.blockOffset);
                } else {
                    this.writerOrNull.int8().writeArrayBlockWithOffset(this.dataSetPath, this.block, this.realBlockSize, this.blockOffset);
                }
            }
            catch (HDF5Exception ex) {
                throw new IOExceptionUnchecked((Throwable)ex);
            }
            this.blockDirty = false;
        }
    }

    @Override
    public void synchronize() throws IOExceptionUnchecked {
        if (this.writerOrNull != null) {
            this.flush();
            try {
                this.writerOrNull.file().flushSyncBlocking();
            }
            catch (HDF5Exception ex) {
                throw new IOExceptionUnchecked((Throwable)ex);
            }
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder == NativeData.ByteOrder.BIG_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder == ByteOrder.BIG_ENDIAN ? NativeData.ByteOrder.BIG_ENDIAN : NativeData.ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public void seek(long pos) throws IOExceptionUnchecked {
        if (pos < 0L) {
            throw new IOExceptionUnchecked("New position may not be negative.");
        }
        if (this.isReadOnly() && pos >= this.length()) {
            throw new IOExceptionUnchecked("In read-only mode, new position may not be larger than file size.");
        }
        long newBlockOffset = pos / (long)this.blockSize * (long)this.blockSize;
        this.positionInBlock = (int)(pos % (long)this.blockSize);
        if (newBlockOffset < this.length()) {
            this.readBlock(newBlockOffset);
        } else {
            this.blockOffset = newBlockOffset;
            this.realBlockSize = this.positionInBlock + 1;
        }
        if (pos >= this.length()) {
            this.extensionPending = true;
        }
    }

    @Override
    public long length() throws IOExceptionUnchecked {
        return this.length;
    }

    @Override
    public void setLength(long newLength) throws IOExceptionUnchecked {
        this.checkWriteDoNotExtend();
        if (!this.extendable) {
            throw new IOExceptionUnchecked("setLength() called on non-extendable dataset.");
        }
        try {
            this.writerOrNull.object().setDataSetSize(this.dataSetPath, newLength);
        }
        catch (HDF5Exception ex) {
            throw new IOExceptionUnchecked((Throwable)ex);
        }
        this.length = newLength;
    }

    @Override
    public void readFully(byte[] b) throws IOExceptionUnchecked {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOExceptionUnchecked {
        int bytesRead = this.read(b, off, len);
        if (bytesRead != len) {
            throw new IOExceptionUnchecked(new EOFException());
        }
    }

    @Override
    public int skipBytes(int n) throws IOExceptionUnchecked {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOExceptionUnchecked {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public byte readByte() throws IOExceptionUnchecked {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte() throws IOExceptionUnchecked {
        int b = this.read();
        if (b < 0) {
            throw new IOExceptionUnchecked(new EOFException());
        }
        return b;
    }

    @Override
    public short readShort() throws IOExceptionUnchecked {
        byte[] byteArr = new byte[2];
        this.readFully(byteArr);
        return NativeData.byteToShort(byteArr, this.byteOrder)[0];
    }

    @Override
    public int readUnsignedShort() throws IOExceptionUnchecked {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOExceptionUnchecked {
        byte[] byteArr = new byte[2];
        this.readFully(byteArr);
        return NativeData.byteToChar(byteArr, this.byteOrder)[0];
    }

    @Override
    public int readInt() throws IOExceptionUnchecked {
        byte[] byteArr = new byte[4];
        this.readFully(byteArr);
        return NativeData.byteToInt(byteArr, this.byteOrder)[0];
    }

    @Override
    public long readLong() throws IOExceptionUnchecked {
        byte[] byteArr = new byte[8];
        this.readFully(byteArr);
        return NativeData.byteToLong(byteArr, this.byteOrder)[0];
    }

    @Override
    public float readFloat() throws IOExceptionUnchecked {
        byte[] byteArr = new byte[4];
        this.readFully(byteArr);
        return NativeData.byteToFloat(byteArr, this.byteOrder)[0];
    }

    @Override
    public double readDouble() throws IOExceptionUnchecked {
        byte[] byteArr = new byte[8];
        this.readFully(byteArr);
        return NativeData.byteToDouble(byteArr, this.byteOrder)[0];
    }

    @Override
    public String readLine() throws IOExceptionUnchecked {
        int b;
        StringBuilder builder = new StringBuilder();
        boolean byteRead = false;
        while ((b = this.read()) >= 0) {
            byteRead = true;
            char c = (char)b;
            if (c == '\r') continue;
            if (c == '\n') break;
            builder.append(c);
        }
        if (!byteRead) {
            return null;
        }
        return builder.toString();
    }

    @Override
    public String readUTF() throws IOExceptionUnchecked {
        try {
            byte[] strBuf = new byte[this.readUnsignedShort()];
            this.readFully(strBuf);
            return new String(strBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void write(int b) throws IOExceptionUnchecked {
        this.checkWrite(1);
        this.extend(1);
        if (this.positionInBlock == this.realBlockSize) {
            this.checkEoFOnWrite();
            this.readNextBlockResetPosition();
            this.checkEoFOnWrite();
        }
        this.block[this.positionInBlock++] = (byte)b;
        this.blockDirty = true;
    }

    @Override
    public void write(byte[] b) throws IOExceptionUnchecked {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOExceptionUnchecked {
        this.checkWrite(len);
        this.extend(len);
        int bytesLeft = len;
        int currentOff = off;
        while (bytesLeft > 0) {
            int lenInBlock = Math.min(bytesLeft, this.bytesLeftInBlock());
            System.arraycopy(b, currentOff, this.block, this.positionInBlock, lenInBlock);
            this.blockDirty = true;
            this.positionInBlock += lenInBlock;
            currentOff += lenInBlock;
            if ((bytesLeft -= lenInBlock) <= 0) continue;
            this.readNextBlockResetPosition();
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOExceptionUnchecked {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOExceptionUnchecked {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOExceptionUnchecked {
        this.write(NativeData.shortToByte(new short[]{(short)v}, this.byteOrder));
    }

    @Override
    public void writeChar(int v) throws IOExceptionUnchecked {
        this.write(NativeData.charToByte(new char[]{(char)v}, this.byteOrder));
    }

    @Override
    public void writeInt(int v) throws IOExceptionUnchecked {
        this.write(NativeData.intToByte(new int[]{v}, this.byteOrder));
    }

    @Override
    public void writeLong(long v) throws IOExceptionUnchecked {
        this.write(NativeData.longToByte(new long[]{v}, this.byteOrder));
    }

    @Override
    public void writeFloat(float v) throws IOExceptionUnchecked {
        this.write(NativeData.floatToByte(new float[]{v}, this.byteOrder));
    }

    @Override
    public void writeDouble(double v) throws IOExceptionUnchecked {
        this.write(NativeData.doubleToByte(new double[]{v}, this.byteOrder));
    }

    @Override
    public void writeBytes(String s) throws IOExceptionUnchecked {
        int i = 0;
        while (i < s.length()) {
            this.write((byte)s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeChars(String s) throws IOExceptionUnchecked {
        int i = 0;
        while (i < s.length()) {
            char v = s.charAt(i);
            this.write((byte)(v >>> 8 & 0xFF));
            this.write((byte)(v >>> 0 & 0xFF));
            ++i;
        }
    }

    @Override
    public void writeUTF(String str) throws IOExceptionUnchecked {
        try {
            byte[] strBuf = str.getBytes("UTF-8");
            this.writeShort(strBuf.length);
            this.write(strBuf);
        }
        catch (UnsupportedEncodingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }
}

