/*
 * Decompiled with CFR 0.152.
 */
package com.github.freva.asciitable;

import com.github.freva.asciitable.ColumnData;
import com.github.freva.asciitable.HorizontalAlign;
import java.util.function.Function;

public class Column {
    private String header;
    private String footer;
    private HorizontalAlign headerAlign = HorizontalAlign.LEFT;
    private HorizontalAlign dataAlign = HorizontalAlign.RIGHT;
    private HorizontalAlign footerAlign = HorizontalAlign.LEFT;
    private int maxColumnWidth = 80;

    public Column() {
    }

    public Column(String header, String footer, HorizontalAlign headerAlign, HorizontalAlign dataAlign, HorizontalAlign footerAlign, int maxColumnWidth) {
        this.header = header;
        this.footer = footer;
        this.headerAlign = headerAlign;
        this.dataAlign = dataAlign;
        this.footerAlign = footerAlign;
        this.maxColumnWidth = maxColumnWidth;
    }

    public String getHeader() {
        return this.header;
    }

    public String getFooter() {
        return this.footer;
    }

    public HorizontalAlign getHeaderAlign() {
        return this.headerAlign;
    }

    public HorizontalAlign getDataAlign() {
        return this.dataAlign;
    }

    public HorizontalAlign getFooterAlign() {
        return this.footerAlign;
    }

    public int getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public int getHeaderWidth() {
        return this.header != null ? this.header.length() : 0;
    }

    public int getFooterWidth() {
        return this.footer != null ? this.footer.length() : 0;
    }

    public Column header(String header) {
        this.header = header;
        return this;
    }

    public Column footer(String footer) {
        this.footer = footer;
        return this;
    }

    public Column headerAlign(HorizontalAlign headerAlign) {
        this.headerAlign = headerAlign;
        return this;
    }

    public Column dataAlign(HorizontalAlign dataAlign) {
        this.dataAlign = dataAlign;
        return this;
    }

    public Column footerAlign(HorizontalAlign footerAlign) {
        this.footerAlign = footerAlign;
        return this;
    }

    public Column maxColumnWidth(int maxColumnWidth) {
        this.maxColumnWidth = maxColumnWidth;
        return this;
    }

    public <T> ColumnData<T> with(Function<T, String> getter) {
        return new ColumnData<T>(this, getter);
    }
}

