/*
 * Decompiled with CFR 0.152.
 */
package com.github.freva.asciitable;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LineUtils {
    public static Stream<String> lines(String str) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new LineIterator(str), 256), false);
    }

    public static int maxLineLength(String str) {
        int max = 0;
        LineIterator lineIterator = new LineIterator(str);
        while (lineIterator.hasNext()) {
            int start = lineIterator.getPosition();
            max = Math.max(max, lineIterator.getLineEndPositionAndAdvanceToNextLine() - start);
        }
        return max;
    }

    private static class LineIterator
    implements Iterator<String> {
        private final String str;
        private int position = 0;

        private LineIterator(String str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.str.length();
        }

        @Override
        public String next() {
            int start = this.position;
            return this.str.substring(start, this.getLineEndPositionAndAdvanceToNextLine());
        }

        public int getLineEndPositionAndAdvanceToNextLine() {
            while (this.position < this.str.length()) {
                char ch = this.str.charAt(this.position);
                if (ch == '\n') {
                    return this.position++;
                }
                if (ch == '\r') {
                    if (this.position + 1 == this.str.length() || this.str.charAt(this.position + 1) != '\n') {
                        return this.position++;
                    }
                    this.position += 2;
                    return this.position - 2;
                }
                ++this.position;
            }
            return this.position;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

