/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.dbmigration.IDataSourceFactory;
import ch.systemsx.cisd.dbmigration.MonitoringDataSource;
import javax.sql.DataSource;

public class BasicDataSourceFactory
implements IDataSourceFactory {
    private static final int DEFAULT_MAX_ACTIVE = 20;
    private static final int DEFAULT_MAX_IDLE = 20;
    private static final int DEFAULT_MAX_WAIT = 60000;
    private static final int DEFAULT_ACTIVE_CONNECTIONS_LOG_INTERVAL = 3600000;
    private long maxWaitMillis = 60000L;
    private int maxIdle = 20;
    private int maxActive = 20;
    private long activeConnectionsLogIntervalMillis = 3600000L;
    private boolean maxIdleIsDefault = true;

    @Override
    public final DataSource createDataSource(String driver, String url, String owner, String password, String validationQuery) {
        MonitoringDataSource dataSource = new MonitoringDataSource();
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(owner);
        dataSource.setPassword(password);
        dataSource.setMaxIdle(this.maxIdle);
        dataSource.setMaxActive(this.maxActive);
        dataSource.setMaxWait(this.maxWaitMillis * 1000L);
        dataSource.setActiveConnectionsLogInterval(this.activeConnectionsLogIntervalMillis);
        dataSource.setValidationQuery(validationQuery);
        return dataSource;
    }

    @Override
    public long getMaxWait() {
        return this.maxWaitMillis;
    }

    @Override
    public void setMaxWait(long maxWait) {
        this.maxWaitMillis = maxWait;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        this.maxIdleIsDefault = false;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        if (this.maxIdleIsDefault) {
            this.maxIdle = maxActive;
        }
    }

    @Override
    public long getActiveConnectionsLogInterval() {
        return this.activeConnectionsLogIntervalMillis;
    }

    @Override
    public void setActiveConnectionsLogInterval(long activeConnectionLogIntervalMillis) {
        this.activeConnectionsLogIntervalMillis = activeConnectionLogIntervalMillis;
    }
}

