/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.BasicDataSourceFactory;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.IDataSourceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jdbc.support.lob.LobHandler;

public class DatabaseConfigurationContext
implements DisposableBean {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DatabaseConfigurationContext.class);
    private ISequenceNameMapper sequenceNameMapper;
    private boolean sequenceUpdateNeeded;
    private String adminUser;
    private String adminPassword;
    private String scriptFolder;
    private List<String> scriptFolders;
    private String databaseKind;
    private DatabaseEngine databaseEngine;
    private String validVersions;
    private boolean createFromScratch;
    private boolean scriptSingleStepMode;
    private IDataSourceFactory dataSourceFactory = new BasicDataSourceFactory();
    private DataSource dataSource;
    private DataSource adminDataSource;
    private String owner;
    private String readOnlyGroup;
    private String readWriteGroup;
    private String password;
    private String basicDatabaseName;
    private String databaseName;
    private String urlHostPart;
    private String databaseInstance;

    public DatabaseConfigurationContext() {
        this.setOwner(null);
        this.setPassword("");
        this.setSequenceUpdateNeeded(true);
    }

    @PostConstruct
    private void setTestEnvironmentHostOrConfigured() {
        this.urlHostPart = DatabaseEngine.getTestEnvironmentHostOrConfigured(this.urlHostPart);
    }

    public final void initDataSourceFactory(IDataSourceFactory factory) {
        this.dataSourceFactory = factory;
    }

    private static final void closeConnection(DataSource dataSource) {
        if (dataSource != null) {
            try {
                if (dataSource instanceof BasicDataSource) {
                    ((BasicDataSource)dataSource).close();
                }
                if (dataSource instanceof DisposableBean) {
                    ((DisposableBean)dataSource).destroy();
                }
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }

    private void checkDatabaseEngine() {
        if (this.databaseEngine == null) {
            throw new ConfigurationFailureException("No db engine defined.");
        }
    }

    private final DataSource createDataSource() {
        String dsDriver = this.getDriver();
        String url = this.getDatabaseURL();
        String validationQuery = this.getValidationQuery();
        this.logParameters();
        return this.dataSourceFactory.createDataSource(dsDriver, url, this.owner, this.password, validationQuery);
    }

    private final void logParameters() {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("driver = %s", this.getDriver()));
            operationLog.info((Object)String.format("databaseURL = %s", this.getDatabaseURL()));
            operationLog.info((Object)String.format("validationQuery = %s", this.getValidationQuery()));
            operationLog.info((Object)String.format("basicDatabaseName = %s", this.getBasicDatabaseName()));
            operationLog.info((Object)String.format("kind = %s", this.getDatabaseKind()));
            operationLog.info((Object)String.format("instance = %s", this.getDatabaseInstance()));
            operationLog.info((Object)String.format("owner = %s", this.getOwner()));
            operationLog.info((Object)String.format("scriptFolder = %s", this.getScriptFolder()));
            operationLog.info((Object)String.format("createFromScratch = %s", this.isCreateFromScratch()));
            operationLog.info((Object)String.format("scriptSingleStepMode = %s", this.isScriptSingleStepMode()));
            operationLog.info((Object)String.format("maxActiveConnections = %d", this.dataSourceFactory.getMaxActive()));
            operationLog.info((Object)String.format("maxIdleConnections = %d", this.dataSourceFactory.getMaxIdle()));
            operationLog.info((Object)String.format("maxWaitForConnectionsMillis = %d", this.dataSourceFactory.getMaxWait()));
            operationLog.info((Object)String.format("activeConnectionsLogIntervalMillis = %d", this.dataSourceFactory.getActiveConnectionsLogInterval()));
        }
    }

    private final String getUrl(String dsDatabaseName) throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getURL(this.urlHostPart, dsDatabaseName);
    }

    private final String getDriver() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getDriverClass();
    }

    private final String getValidationQuery() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getValidationQuery();
    }

    private final String getAdminUser() throws ConfigurationFailureException {
        if (this.adminUser == null) {
            this.checkDatabaseEngine();
            return this.databaseEngine.getDefaultAdminUser();
        }
        return this.adminUser;
    }

    private final String getAdminPassword() {
        return this.adminPassword;
    }

    private final String getDatabaseKind() {
        return this.databaseKind;
    }

    public final String getDatabaseURL() {
        String dsDatabaseName = this.getDatabaseName();
        if (dsDatabaseName == null) {
            throw new ConfigurationFailureException("No db name defined.");
        }
        String url = this.getUrl(dsDatabaseName);
        return url;
    }

    public final DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    public String getBasicDatabaseName() {
        return this.basicDatabaseName;
    }

    public final DataSource getAdminDataSource() throws ConfigurationFailureException {
        if (this.adminDataSource == null) {
            this.adminDataSource = this.dataSourceFactory.createDataSource(this.getDriver(), this.getAdminURL(), this.getAdminUser(), this.getAdminPassword(), this.getValidationQuery());
        }
        return this.adminDataSource;
    }

    public final String getOwner() {
        return this.owner;
    }

    public final void setOwner(String owner) {
        this.owner = StringUtils.isBlank((CharSequence)owner) ? System.getProperty("user.name").toLowerCase() : owner;
    }

    public String getReadOnlyGroup() {
        return this.readOnlyGroup;
    }

    public void setReadOnlyGroup(String readOnlyGroup) {
        this.readOnlyGroup = readOnlyGroup;
    }

    public String getReadWriteGroup() {
        return this.readWriteGroup;
    }

    public void setReadWriteGroup(String readWriteGroup) {
        this.readWriteGroup = readWriteGroup;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password == null ? "" : password;
    }

    public final void setAdminUser(String adminUser) {
        this.adminUser = adminUser != null && adminUser.length() == 0 ? null : StringUtils.trim((String)adminUser);
    }

    public void setBasicDatabaseName(String basicDatabaseName) {
        this.basicDatabaseName = StringUtils.trim((String)basicDatabaseName);
    }

    public String getDatabaseName() {
        if (this.databaseName == null) {
            this.databaseName = this.getBasicDatabaseName() + "_" + this.getDatabaseKind();
        }
        return this.databaseName;
    }

    public final void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public final String getUrlHostPart() {
        return this.urlHostPart;
    }

    public final void setUrlHostPart(String urlHostPart) {
        this.urlHostPart = this.isSet(urlHostPart) ? StringUtils.trim((String)urlHostPart) : null;
        this.setTestEnvironmentHostOrConfigured();
    }

    private boolean isSet(String propertyValueStr) {
        return StringUtils.isNotBlank((CharSequence)propertyValueStr) && !propertyValueStr.startsWith("${");
    }

    public void setMaxWaitForConnectionProp(String maxWaitStr) {
        if (this.isSet(maxWaitStr)) {
            this.dataSourceFactory.setMaxWait((long)Integer.parseInt(maxWaitStr) * 1000L);
        }
    }

    public void setMaxIdleConnectionsProp(String maxIdleStr) {
        if (this.isSet(maxIdleStr)) {
            this.dataSourceFactory.setMaxIdle(Integer.parseInt(maxIdleStr));
        }
    }

    public void setMaxActiveConnectionsProp(String maxActiveStr) {
        if (this.isSet(maxActiveStr)) {
            this.dataSourceFactory.setMaxActive(Integer.parseInt(maxActiveStr));
        }
    }

    public void setActiveConnectionsLogIntervalProp(String activeConnectionLogIntervalStr) {
        if (this.isSet(activeConnectionLogIntervalStr)) {
            this.dataSourceFactory.setActiveConnectionsLogInterval((long)Integer.parseInt(activeConnectionLogIntervalStr) * 1000L);
        }
    }

    private final String getAdminURL() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getAdminURL(this.urlHostPart, this.getDatabaseName());
    }

    public final LobHandler getLobHandler() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getLobHandler();
    }

    public final ISequencerHandler getSequencerHandler() throws ConfigurationFailureException {
        this.checkDatabaseEngine();
        return this.databaseEngine.getSequenceHandler();
    }

    public final ISequenceNameMapper getSequenceNameMapper() {
        return this.sequenceNameMapper;
    }

    public final void setSequenceNameMapper(ISequenceNameMapper sequenceNameMapper) {
        this.sequenceNameMapper = sequenceNameMapper;
    }

    public final boolean isSequenceUpdateNeeded() {
        return this.sequenceUpdateNeeded;
    }

    public final void setSequenceUpdateNeeded(boolean sequenceUpdateNeeded) {
        this.sequenceUpdateNeeded = sequenceUpdateNeeded;
    }

    public final boolean isCreateFromScratch() {
        return this.createFromScratch;
    }

    public final void setCreateFromScratch(boolean createFromScratch) {
        this.createFromScratch = createFromScratch;
    }

    public final void setCreateFromScratchProp(String createFromScratchStr) {
        if (this.isSet(createFromScratchStr)) {
            this.setCreateFromScratch(Boolean.parseBoolean(createFromScratchStr));
        }
    }

    public final boolean isScriptSingleStepMode() {
        return this.scriptSingleStepMode;
    }

    public final void setScriptSingleStepMode(boolean singleStepMode) {
        this.scriptSingleStepMode = singleStepMode;
    }

    public final void setScriptSingleStepModeProp(String singleStepModeStr) {
        if (this.isSet(singleStepModeStr)) {
            this.setScriptSingleStepMode(Boolean.parseBoolean(singleStepModeStr));
        }
    }

    public final void setDatabaseKind(String databaseKind) {
        this.databaseKind = StringUtils.trim((String)databaseKind);
    }

    public DatabaseEngine getDatabaseEngine() throws ConfigurationFailureException {
        if (this.databaseEngine == null) {
            throw new ConfigurationFailureException("No database engine defined.");
        }
        return this.databaseEngine;
    }

    public final String getDatabaseEngineCode() throws ConfigurationFailureException {
        if (this.databaseEngine == null) {
            throw new ConfigurationFailureException("No database engine defined.");
        }
        return this.databaseEngine.getCode();
    }

    public final void setDatabaseEngineCode(String databaseEngineCode) throws ConfigurationFailureException {
        this.databaseEngine = this.isSet(databaseEngineCode) ? DatabaseEngine.getEngineForCode(StringUtils.trim((String)databaseEngineCode)) : DatabaseEngine.POSTGRESQL;
    }

    public final String getValidVersions() {
        return this.validVersions;
    }

    public final void setValidVersions(String validVersions) {
        if (this.isSet(validVersions)) {
            this.validVersions = validVersions;
        }
    }

    public final IDAOFactory createDAOFactory() {
        return this.databaseEngine.createDAOFactory(this);
    }

    public final String getScriptFolder() {
        return this.scriptFolder;
    }

    public final void setScriptFolder(String scriptFolder) {
        this.scriptFolder = scriptFolder;
    }

    public List<String> getSqlScriptFolders() {
        if (this.scriptFolder != null && this.variablesResolved(this.scriptFolder)) {
            return Arrays.asList(this.scriptFolder);
        }
        if (this.scriptFolders != null && this.scriptFolders.size() > 0 && this.variablesResolved(this.scriptFolders.get(0))) {
            return this.scriptFolders;
        }
        return Collections.emptyList();
    }

    private boolean variablesResolved(String value) {
        return value.indexOf("${") < 0;
    }

    public void setScriptFolders(String scriptFolders) {
        this.scriptFolders = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(scriptFolders, ",");
        while (tokenizer.hasMoreTokens()) {
            this.scriptFolders.add(tokenizer.nextToken().trim());
        }
    }

    public final String getDatabaseInstance() {
        return StringUtils.trim((String)this.databaseInstance);
    }

    public final void setDatabaseInstance(String databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    public final void closeConnections() {
        DatabaseConfigurationContext.closeConnection(this.dataSource);
        this.dataSource = null;
        DatabaseConfigurationContext.closeConnection(this.adminDataSource);
        this.adminDataSource = null;
    }

    public final void destroy() throws Exception {
        this.closeConnections();
    }
}

