/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.dbmigration.TableColumnDefinition;
import ch.systemsx.cisd.dbmigration.TableDefinition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class DatabaseDefinition
implements Iterable<TableDefinition> {
    private final Map<String, TableDefinition> tableDefinitions = new TreeMap<String, TableDefinition>();

    public void add(TableDefinition tableDefinition) {
        this.tableDefinitions.put(tableDefinition.getTableName(), tableDefinition);
    }

    public TableDefinition getTableDefinition(String tableName) {
        TableDefinition tableDefinition = this.tableDefinitions.get(tableName);
        if (tableDefinition == null) {
            throw new IllegalArgumentException("Unknown table '" + tableName + "'.");
        }
        return tableDefinition;
    }

    public void connect(String pkTableName, String pkColumnName, String fkTableName, String fkColumnName) {
        TableDefinition pkTableDefinition = this.getTableDefinition(pkTableName);
        TableColumnDefinition pkColumnDefinition = pkTableDefinition.getColumnDefinition(pkColumnName);
        TableDefinition fkTableDefinition = this.getTableDefinition(fkTableName);
        TableColumnDefinition fkColumnDefinition = fkTableDefinition.getColumnDefinition(fkColumnName);
        pkColumnDefinition.addConnection(fkColumnDefinition);
    }

    @Override
    public Iterator<TableDefinition> iterator() {
        return this.tableDefinitions.values().iterator();
    }

    public Set<TableDefinition> getTablesDependingOn(String ... tableNames) {
        TreeSet<TableDefinition> collection = new TreeSet<TableDefinition>();
        HashSet<String> visitedTableDefinitions = new HashSet<String>();
        for (String tableName : tableNames) {
            this.collectTablesDependingOn(this.getTableDefinition(tableName), collection, visitedTableDefinitions);
        }
        return collection;
    }

    private void collectTablesDependingOn(TableDefinition tableDefinition, Set<TableDefinition> collection, Set<String> visitedTableDefinitions) {
        if (visitedTableDefinitions.contains(tableDefinition.getTableName())) {
            return;
        }
        visitedTableDefinitions.add(tableDefinition.getTableName());
        for (TableColumnDefinition tableColumnDefinition : tableDefinition) {
            for (TableColumnDefinition tableColumnDefinition2 : tableColumnDefinition) {
                TableDefinition dependentTable = tableColumnDefinition2.getTableDefinition();
                collection.add(dependentTable);
                this.collectTablesDependingOn(dependentTable, collection, visitedTableDefinitions);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TableDefinition tableDefinition : this.tableDefinitions.values()) {
            builder.append(tableDefinition).append('\n');
        }
        return builder.toString();
    }
}

