/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.MonitoringPoolingDataSource;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Logger;

public class MonitoringDataSource
extends BasicDataSource {
    private static final Logger machineLog = LogFactory.getLogger((LogCategory)LogCategory.MACHINE, MonitoringPoolingDataSource.class);
    private long activeConnectionsLogInterval;

    public synchronized void setUrl(String url) {
        if (machineLog.isDebugEnabled()) {
            Throwable th = new Throwable();
            th.fillInStackTrace();
            machineLog.debug((Object)("Creating data source '" + url + "'."), th);
        }
        super.setUrl(url);
    }

    public long getActiveConnectionsLogInterval() {
        return this.activeConnectionsLogInterval;
    }

    public void setActiveConnectionsLogInterval(long activeConnectionLogInterval) {
        this.activeConnectionsLogInterval = activeConnectionLogInterval;
    }

    protected void createDataSourceInstance() throws SQLException {
        MonitoringPoolingDataSource pds = new MonitoringPoolingDataSource((ObjectPool)this.connectionPool, this.url, this.activeConnectionsLogInterval);
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        pds.setLogWriter(this.logWriter);
        this.dataSource = pds;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public synchronized void close() throws SQLException {
        if (machineLog.isDebugEnabled()) {
            Throwable th = new Throwable();
            th.fillInStackTrace();
            machineLog.debug((Object)("Closing data source '" + this.getUrl() + "'."), th);
        }
        super.close();
    }
}

