/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.dbmigration.BasicDataSourceFactory;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import ch.systemsx.cisd.dbmigration.IDataSourceFactory;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;

public class SimpleDatabaseConfigurationContext
implements DisposableBean {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SimpleDatabaseConfigurationContext.class);
    public static final String DRIVER_KEY = "database-driver";
    public static final String URL_KEY = "database-url";
    public static final String USER_KEY = "database-username";
    public static final String PASSWORD_KEY = "database-password";
    static final String MAX_IDLE_KEY = "database-max-idle-connections";
    static final String MAX_ACTIVE_KEY = "database-max-active-connections";
    static final String MAX_WAIT_FOR_CONNECTION = "database-max-wait-for-connection";
    static final String ACTIVE_CONNECTIONS_LOG_INTERVAL = "database-active-connections-log-interval";
    static final String VALIDATION_QUERY_KEY = "validation-query";
    private IDataSourceFactory dataSourceFactory = new BasicDataSourceFactory();
    private DataSource dataSource;
    private final String driverClassName;
    private final String url;
    private final String username;
    private final String password;
    private final String validationQuery;

    public SimpleDatabaseConfigurationContext(String driverClassName, String url, String username, String password, String validationQuery) {
        this.driverClassName = driverClassName;
        this.url = DatabaseEngine.getTestEnvironmentURLOrConfigured(url);
        this.username = username;
        this.password = password;
        this.validationQuery = validationQuery;
    }

    public SimpleDatabaseConfigurationContext(Properties properties) {
        this.driverClassName = PropertyUtils.getMandatoryProperty((Properties)properties, (String)DRIVER_KEY);
        this.url = DatabaseEngine.getTestEnvironmentURLOrConfigured(PropertyUtils.getMandatoryProperty((Properties)properties, (String)URL_KEY));
        this.username = PropertyUtils.getProperty((Properties)properties, (String)USER_KEY, (String)System.getProperty("user.name").toLowerCase());
        this.password = PropertyUtils.getProperty((Properties)properties, (String)PASSWORD_KEY);
        if (PropertyUtils.hasProperty((Properties)properties, (String)MAX_ACTIVE_KEY)) {
            this.dataSourceFactory.setMaxActive(PropertyUtils.getInt((Properties)properties, (String)MAX_ACTIVE_KEY, (int)-1));
        }
        if (PropertyUtils.hasProperty((Properties)properties, (String)MAX_IDLE_KEY)) {
            this.dataSourceFactory.setMaxIdle(PropertyUtils.getInt((Properties)properties, (String)MAX_IDLE_KEY, (int)-1));
        }
        if (PropertyUtils.hasProperty((Properties)properties, (String)MAX_WAIT_FOR_CONNECTION)) {
            this.dataSourceFactory.setMaxWait(PropertyUtils.getInt((Properties)properties, (String)MAX_WAIT_FOR_CONNECTION, (int)-1));
        }
        if (PropertyUtils.hasProperty((Properties)properties, (String)ACTIVE_CONNECTIONS_LOG_INTERVAL)) {
            this.dataSourceFactory.setActiveConnectionsLogInterval(PropertyUtils.getInt((Properties)properties, (String)ACTIVE_CONNECTIONS_LOG_INTERVAL, (int)-1));
        }
        this.validationQuery = PropertyUtils.getProperty((Properties)properties, (String)VALIDATION_QUERY_KEY);
        operationLog.info((Object)("Database configuration for URL '" + this.url + "' created."));
    }

    public final DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    private final DataSource createDataSource() {
        return this.dataSourceFactory.createDataSource(this.driverClassName, this.url, this.username, this.password, this.validationQuery);
    }

    public final void closeConnections() {
        SimpleDatabaseConfigurationContext.closeConnection(this.dataSource);
        this.dataSource = null;
    }

    public final void destroy() throws Exception {
        this.closeConnections();
    }

    private static final void closeConnection(DataSource dataSource) {
        if (dataSource != null) {
            try {
                if (dataSource instanceof BasicDataSource) {
                    ((BasicDataSource)dataSource).close();
                }
                if (dataSource instanceof DisposableBean) {
                    ((DisposableBean)dataSource).destroy();
                }
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }
}

