/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.java;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.Script;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.parser.ILine;
import ch.systemsx.cisd.common.parser.ParserUtilities;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.java.IMigrationStep;
import ch.systemsx.cisd.dbmigration.java.IMigrationStepExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class MigrationStepExecutor
extends JdbcDaoSupport
implements IMigrationStepExecutor {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MigrationStepExecutor.class);
    private static final String JAVA_MIGRATION_STEP_PREFIX = "--JAVA";
    private static final String JAVA_ADMIN_MIGRATION_STEP_PREFIX = "--JAVA_ADMIN";
    private final boolean isAdmin;
    private final DatabaseConfigurationContext dbConfigurationContext;
    private IMigrationStep migrationStep;
    private boolean inited;

    public MigrationStepExecutor(DatabaseConfigurationContext dbConfigurationContext, boolean isAdmin) {
        this.dbConfigurationContext = dbConfigurationContext;
        this.isAdmin = isAdmin;
        this.setDataSource(isAdmin ? dbConfigurationContext.getAdminDataSource() : dbConfigurationContext.getDataSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IMigrationStep tryExtractMigrationStep(Script sqlScript) {
        assert (sqlScript != null) : "SQL script not provided";
        String content = sqlScript.getContent();
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try (ParserUtilities.LineSplitter splitter = new ParserUtilities.LineSplitter(content, new ILineFilter(){

            public <T> boolean acceptLine(ILine<T> line) {
                String text = line.getText();
                return StringUtils.isNotBlank((CharSequence)text) && text.startsWith("--");
            }
        });){
            ILine lineOrNull;
            IMigrationStep stepOrNull = null;
            while (stepOrNull == null && (lineOrNull = splitter.tryNextLine()) != null) {
                stepOrNull = this.tryExtractMigrationStepFromLine(lineOrNull.getText());
            }
            IMigrationStep iMigrationStep = stepOrNull;
            return iMigrationStep;
        }
    }

    private final IMigrationStep tryExtractMigrationStepFromLine(String lineToProcess) {
        String prefix;
        String line = StringUtils.deleteWhitespace((String)lineToProcess);
        if (!this.isAdmin && line.startsWith(JAVA_ADMIN_MIGRATION_STEP_PREFIX)) {
            return null;
        }
        String string = prefix = this.isAdmin ? JAVA_ADMIN_MIGRATION_STEP_PREFIX : JAVA_MIGRATION_STEP_PREFIX;
        if (line != null && line.startsWith(prefix)) {
            String className = StringUtils.removeStart((String)line, (String)prefix);
            try {
                if (ClassUtils.hasConstructor(Class.forName(className), (Object[])new Object[]{this.dbConfigurationContext})) {
                    return (IMigrationStep)ClassUtils.create(IMigrationStep.class, Class.forName(className), (Object[])new Object[]{this.dbConfigurationContext});
                }
                return (IMigrationStep)ClassUtils.createInstance(Class.forName(className));
            }
            catch (ClassNotFoundException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        return null;
    }

    @Override
    public final void init(Script migrationScript) {
        this.migrationStep = this.tryExtractMigrationStep(migrationScript);
        if (this.migrationStep != null) {
            operationLog.info((Object)String.format("Migration step class '%s' found for migration script '%s'.", this.migrationStep.getClass().getSimpleName(), migrationScript.getName()));
        } else {
            operationLog.debug((Object)String.format("No migration step class found for migration script '%s'.", migrationScript.getName()));
        }
        this.inited = true;
    }

    @Override
    public final void performPreMigration() {
        assert (this.inited) : "Executor not initialized.";
        if (this.migrationStep != null) {
            this.migrationStep.performPreMigration(this.getJdbcTemplate(), this.getDataSource());
        }
    }

    @Override
    public final void performPostMigration() {
        assert (this.inited) : "Executor not initialized.";
        if (this.migrationStep != null) {
            this.migrationStep.performPostMigration(this.getJdbcTemplate(), this.getDataSource());
        }
    }

    @Override
    public final void finish() {
        this.inited = false;
        this.migrationStep = null;
    }
}

