/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.postgresql;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.utilities.VersionUtils;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.DatabaseVersionLogDAO;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.IDatabaseVersionLogDAO;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.SqlScriptExecutor;
import ch.systemsx.cisd.dbmigration.java.IMigrationStepExecutor;
import ch.systemsx.cisd.dbmigration.java.MigrationStepExecutor;
import ch.systemsx.cisd.dbmigration.postgresql.PostgreSQLAdminDAO;
import ch.systemsx.cisd.dbmigration.postgresql.PostgreSQLMassUploader;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;

public class PostgreSQLDAOFactory
implements IDAOFactory {
    private static final String DEFAULT_VALID_VERSIONS = "11";
    private final IDatabaseAdminDAO databaseDAO;
    private final ISqlScriptExecutor sqlScriptExecutor;
    private final IDatabaseVersionLogDAO databaseVersionLogDAO;
    private final IMassUploader massUploader;
    private final IMigrationStepExecutor migrationStepExecutor;
    private final IMigrationStepExecutor migrationStepExecutorAdmin;

    public PostgreSQLDAOFactory(DatabaseConfigurationContext context) {
        DataSource dataSource = context.getDataSource();
        this.sqlScriptExecutor = new SqlScriptExecutor(dataSource, context.isScriptSingleStepMode());
        this.migrationStepExecutor = new MigrationStepExecutor(context, false);
        this.migrationStepExecutorAdmin = new MigrationStepExecutor(context, true);
        this.databaseVersionLogDAO = new DatabaseVersionLogDAO(dataSource, context.getLobHandler());
        try {
            ISequenceNameMapper mapper = context.getSequenceNameMapper();
            boolean sequenceUpdateNeeded = context.isSequenceUpdateNeeded();
            this.massUploader = new PostgreSQLMassUploader(dataSource, mapper, sequenceUpdateNeeded);
        }
        catch (SQLException ex) {
            throw new CheckedExceptionTunnel((Exception)ex);
        }
        this.databaseDAO = new PostgreSQLAdminDAO(context.getAdminDataSource(), this.sqlScriptExecutor, this.massUploader, context.getOwner(), context.getReadOnlyGroup(), context.getReadWriteGroup(), context.getDatabaseName(), context.getDatabaseURL());
        if (System.getenv().containsKey("FORCE_OPENBIS_POSTGRES_VALID_VERSIONS")) {
            this.assertValidVersion(this.databaseDAO.getDatabaseServerVersion(), System.getenv().get("FORCE_OPENBIS_POSTGRES_VALID_VERSIONS"));
        } else {
            this.assertValidVersion(this.databaseDAO.getDatabaseServerVersion(), context.getValidVersions());
        }
    }

    private void assertValidVersion(String databaseServerVersion, String validVersions) {
        List<String> validVersionsList = Arrays.asList((validVersions != null ? validVersions : DEFAULT_VALID_VERSIONS).split(" "));
        for (String validVersion : validVersionsList) {
            if (!VersionUtils.isCompatible((String)validVersion, (String)databaseServerVersion, (boolean)false)) continue;
            return;
        }
        throw new ConfigurationFailureException("The database server version " + databaseServerVersion + " is not a valid version. Valid versions are " + validVersionsList);
    }

    @Override
    public IDatabaseAdminDAO getDatabaseDAO() {
        return this.databaseDAO;
    }

    @Override
    public ISqlScriptExecutor getSqlScriptExecutor() {
        return this.sqlScriptExecutor;
    }

    @Override
    public IDatabaseVersionLogDAO getDatabaseVersionLogDAO() {
        return this.databaseVersionLogDAO;
    }

    @Override
    public IMassUploader getMassUploader() {
        return this.massUploader;
    }

    @Override
    public IMigrationStepExecutor getMigrationStepExecutor() {
        return this.migrationStepExecutor;
    }

    @Override
    public IMigrationStepExecutor getMigrationStepExecutorAdmin() {
        return this.migrationStepExecutorAdmin;
    }
}

