/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import com.marathon.util.spring.StreamSupportingRemoteInvocation;
import com.marathon.util.spring.StreamSupportingRemoteInvocationResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.springframework.remoting.httpinvoker.AbstractHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.rmi.CodebaseAwareObjectInputStream;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class JettyHttpInvokerRequestExecutor
extends AbstractHttpInvokerRequestExecutor {
    private static final long RESPONSE_BUFFER_SIZE = 1048576000L;
    private static final Log log = LogFactory.getLog(JettyHttpInvokerRequestExecutor.class);
    private final HttpClient client;
    private final long serverTimeoutInMillis;

    public JettyHttpInvokerRequestExecutor(HttpClient client, long serverTimeoutInMillis) {
        this.client = client;
        this.serverTimeoutInMillis = serverTimeoutInMillis <= 0L ? serverTimeoutInMillis : Math.max(1000L, serverTimeoutInMillis);
    }

    protected RemoteInvocationResult doExecuteBasicRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws Exception {
        Request request = this.client.POST(config.getServiceUrl()).content(new BytesContentProvider(new byte[][]{baos.toByteArray()})).timeout(this.serverTimeoutInMillis, TimeUnit.MILLISECONDS);
        FutureResponseListener listener = new FutureResponseListener(request, 1048576000);
        request.send(listener);
        ContentResponse response = listener.get();
        return this.readRemoteInvocationResult(new ByteArrayInputStream(response.getContent()), config.getCodebaseUrl());
    }

    @Override
    protected ByteArrayOutputStream getByteArrayOutputStream(RemoteInvocation invocation) throws IOException {
        WorkaroundByteArrayOutputStream baos = new WorkaroundByteArrayOutputStream(1024, invocation);
        this.writeRemoteInvocation(invocation, baos);
        return baos;
    }

    @Override
    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws Exception {
        WorkaroundByteArrayOutputStream wbaos = (WorkaroundByteArrayOutputStream)baos;
        if (wbaos.getRemoteInvocation() instanceof StreamSupportingRemoteInvocation) {
            return this.doExecuteRequest(config, wbaos, (StreamSupportingRemoteInvocation)wbaos.getRemoteInvocation());
        }
        return this.doExecuteBasicRequest(config, baos);
    }

    @Override
    protected RemoteInvocationResult readRemoteInvocationResult(InputStream is, String codebaseUrl) throws IOException, ClassNotFoundException {
        RemoteInvocationResult ret = super.readRemoteInvocationResult(is, codebaseUrl);
        if (!(ret instanceof StreamSupportingRemoteInvocationResult)) {
            is.close();
        }
        return ret;
    }

    @Override
    protected ObjectInputStream createObjectInputStream(InputStream is, String codebaseUrl) throws IOException {
        return new SourceStreamPreservingObjectInputStream(is, codebaseUrl);
    }

    @Override
    protected RemoteInvocationResult doReadRemoteInvocationResult(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        RemoteInvocationResult source = super.doReadRemoteInvocationResult(ois);
        if (source instanceof StreamSupportingRemoteInvocationResult) {
            ((StreamSupportingRemoteInvocationResult)source).setClientSideInputStream(((SourceStreamPreservingObjectInputStream)ois).getSourceInputStream());
        }
        return source;
    }

    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos, StreamSupportingRemoteInvocation invocation) throws IOException, ClassNotFoundException {
        Request postMethod;
        if (invocation.getClientSideInputStream() != null) {
            ByteArrayInputStream serializedInvocation = new ByteArrayInputStream(baos.toByteArray());
            CompositeInputStream body = new CompositeInputStream(new InputStream[]{serializedInvocation, new CloseShieldedInputStream(invocation.getClientSideInputStream())});
            postMethod = this.client.POST(config.getServiceUrl()).header("Content-Type", "application/x-java-serialized-object-with-stream").content(new InputStreamContentProvider(body), "application/x-java-serialized-object-with-stream");
        } else {
            postMethod = this.client.POST(config.getServiceUrl()).content(new BytesContentProvider(new byte[][]{baos.toByteArray()}));
        }
        InputStreamResponseListener listener = new InputStreamResponseListener();
        postMethod.timeout(this.serverTimeoutInMillis, TimeUnit.MILLISECONDS).send(listener);
        RemoteInvocationResult ret = this.readRemoteInvocationResult(listener.getInputStream(), config.getCodebaseUrl());
        if (ret instanceof StreamSupportingRemoteInvocationResult) {
            InputStream sourceRetIs;
            StreamSupportingRemoteInvocationResult ssrir = (StreamSupportingRemoteInvocationResult)ret;
            if (invocation.getClientSideInputStream() != null) {
                if (ssrir.getMethodClosedParamInputStream() != null) {
                    if (Boolean.TRUE.equals(ssrir.getMethodClosedParamInputStream())) {
                        invocation.getClientSideInputStream().close();
                    }
                } else {
                    this.warnInputStreamParameterStateNotSpecified(invocation);
                }
            }
            if (ssrir.getHasReturnStream() && (sourceRetIs = ssrir.getClientSideInputStream()) != null) {
                ssrir.setClientSideInputStream(new FilterInputStream(sourceRetIs){

                    @Override
                    public void close() throws IOException {
                        super.close();
                    }
                });
            }
        } else if (invocation.getClientSideInputStream() != null) {
            this.warnInputStreamParameterStateNotSpecified(invocation);
        }
        return ret;
    }

    private void warnInputStreamParameterStateNotSpecified(StreamSupportingRemoteInvocation invocation) {
        log.warn("Remote method invocation with InputStream parameter did not indicate if remote method closed the InputStream parameter!  Will leave the stream open.  RemoteInvocation: " + invocation);
    }

    public static class CompositeInputStream
    extends FilterInputStream {
        private InputStream[] inputStreams;
        private int currentInputStreamIdx;

        public CompositeInputStream(InputStream[] inputStreams) {
            super(inputStreams[0]);
            this.inputStreams = inputStreams;
            this.currentInputStreamIdx = 0;
        }

        public InputStream[] getInputStreams() {
            return this.inputStreams;
        }

        public int getCurrentInputStreamIdx() {
            return this.currentInputStreamIdx;
        }

        protected InputStream incCurrentInputStream() throws IOException {
            if (++this.currentInputStreamIdx >= this.getInputStreams().length) {
                return null;
            }
            this.in.close();
            this.in = this.getInputStreams()[this.currentInputStreamIdx];
            return this.in;
        }

        @Override
        public int read() throws IOException {
            int read = super.read();
            if (read == -1) {
                if (this.incCurrentInputStream() == null) {
                    return -1;
                }
                return this.read();
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = super.read(b);
            if (read == -1) {
                if (this.incCurrentInputStream() == null) {
                    return -1;
                }
                return this.read(b);
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read == -1) {
                if (this.incCurrentInputStream() == null) {
                    return -1;
                }
                return this.read(b, off, len);
            }
            return read;
        }

        @Override
        public void close() throws IOException {
            InputStream[] myInputStreams = this.getInputStreams();
            for (int i = this.getCurrentInputStreamIdx(); i < myInputStreams.length; ++i) {
                myInputStreams[i].close();
            }
        }
    }

    public static class CloseShieldedInputStream
    extends FilterInputStream {
        public CloseShieldedInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static class SourceStreamPreservingObjectInputStream
    extends CodebaseAwareObjectInputStream {
        private InputStream sourceInputStream;

        public SourceStreamPreservingObjectInputStream(InputStream in, String codebaseUrl) throws IOException {
            super((InputStream)new CloseShieldedInputStream(in), codebaseUrl);
            this.sourceInputStream = in;
        }

        public InputStream getSourceInputStream() {
            return this.sourceInputStream;
        }
    }

    public static class WorkaroundByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final RemoteInvocation remoteInvocation;

        public WorkaroundByteArrayOutputStream(int size, RemoteInvocation remoteInvocation) {
            super(size);
            this.remoteInvocation = remoteInvocation;
        }

        public RemoteInvocation getRemoteInvocation() {
            return this.remoteInvocation;
        }
    }
}

