/*
 * Decompiled with CFR 0.152.
 */
package com.marathon.util.spring;

import com.marathon.util.spring.RemoteInvocationDecorator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.support.RemoteInvocation;

public class StreamSupportingRemoteInvocation
extends RemoteInvocationDecorator {
    private static final long serialVersionUID = 1L;
    private transient InputStream clientSideInputStream;
    private int inputStreamParam;
    private boolean inputStreamParamNull;

    public StreamSupportingRemoteInvocation() {
    }

    public StreamSupportingRemoteInvocation(RemoteInvocation source) {
        super(source);
    }

    public static boolean isInputStreamInvocation(MethodInvocation mi, boolean matchOnMethodSignature) {
        return InputStream.class.isAssignableFrom(mi.getMethod().getReturnType()) || StreamSupportingRemoteInvocation.getInputStreamParam(mi.getMethod().getParameterTypes(), mi.getArguments(), matchOnMethodSignature) != -1;
    }

    public static int getInputStreamParam(Class[] paramTypes, Object[] params, boolean matchOnMethodSignature) {
        int inputStreamParam = -1;
        int i = paramTypes.length - 1;
        while (i >= 0) {
            if (matchOnMethodSignature && InputStream.class.isAssignableFrom(paramTypes[i]) || !matchOnMethodSignature && params[i] instanceof InputStream) {
                if (inputStreamParam == -1) {
                    inputStreamParam = i;
                } else {
                    throw new UnsupportedOperationException("Remote invocation supports at most 1 InputStream parameters.");
                }
            }
            --i;
        }
        return inputStreamParam;
    }

    public void setupInputStreamParam(boolean matchOnMethodSignature) {
        Class[] paramTypes = this.getParameterTypes();
        Object[] params = this.getArguments();
        if (paramTypes != null) {
            int myInputStreamParam = StreamSupportingRemoteInvocation.getInputStreamParam(paramTypes, params, matchOnMethodSignature);
            this.setInputStreamParam(myInputStreamParam);
            if (myInputStreamParam != -1) {
                if (paramTypes[myInputStreamParam] == null) {
                    this.setInputStreamParamNull(true);
                } else {
                    this.setInputStreamParamNull(false);
                    this.setClientSideInputStream((InputStream)params[myInputStreamParam]);
                    params[myInputStreamParam] = null;
                }
            }
        }
    }

    public Object invoke(Object targetObject, InputStream serverSideInputStream) throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (this.getInputStreamParam() != -1 && !this.isInputStreamParamNull()) {
            Object[] params = this.getArguments();
            params[this.getInputStreamParam()] = serverSideInputStream;
        } else {
            serverSideInputStream.close();
        }
        return this.invoke(targetObject);
    }

    public InputStream getClientSideInputStream() {
        return this.clientSideInputStream;
    }

    public void setClientSideInputStream(InputStream clientSideInputStream) {
        this.clientSideInputStream = clientSideInputStream;
    }

    public int getInputStreamParam() {
        return this.inputStreamParam;
    }

    protected void setInputStreamParam(int inputStreamParam) {
        this.inputStreamParam = inputStreamParam;
    }

    public boolean isInputStreamParamNull() {
        return this.inputStreamParamNull;
    }

    protected void setInputStreamParamNull(boolean inputStreamParamNull) {
        this.inputStreamParamNull = inputStreamParamNull;
    }
}

