/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.shared.basic.string;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlternativesStringFilter {
    private static final String PREFIX_NOT = "!";
    private static final String PREFIX_START_ANCHOR = "^";
    private static final String SUFFIX_END_ANCHOR = "$";
    private static final String ESCAPE = "\\";
    private static final String SUFFIX_ESCAPED_END_ANCHOR = "\\$";
    private List<Matcher> alternatives = new ArrayList<Matcher>();
    private static Map<String, ComparisonKind> comparisonKindByOperator = new HashMap<String, ComparisonKind>();

    public void setFilterValue(String value) {
        this.setFilterValue(value, new IMatcherFactory(){

            @Override
            public Matcher tryToCreate(String description) {
                return AlternativesStringFilter.this.tryGetNumericMatcher(description);
            }
        });
    }

    public void setFilterValue(String value, IMatcherFactory factory) {
        this.alternatives.clear();
        boolean conjunct = false;
        for (String s : StringUtils.tokenize(value)) {
            Matcher matcher;
            if (s.equals("&") && this.alternatives.size() > 0) {
                conjunct = true;
                continue;
            }
            boolean negateValue = s.startsWith(PREFIX_NOT);
            if (negateValue) {
                s = s.substring(1);
            }
            if ((matcher = factory.tryToCreate(s)) == null) {
                matcher = this.getStringMatcher(s);
            }
            if (negateValue) {
                matcher = new NegationMatcher(matcher);
            }
            if (conjunct) {
                Matcher previousMatcher = this.alternatives.remove(this.alternatives.size() - 1);
                matcher = new ConjunctionMatcher(previousMatcher, matcher);
                conjunct = false;
            }
            this.alternatives.add(matcher);
        }
    }

    public void setDateFilterValue(String value) {
        this.setFilterValue(value, new IMatcherFactory(){

            @Override
            public Matcher tryToCreate(String description) {
                String filterValue = description;
                ComparisonKind comparisonKindOrNull = null;
                if (description != null && description.length() >= 2 && "<>=".indexOf(description.charAt(0)) > -1) {
                    int operatorLength = description.charAt(1) == '=' ? 2 : 1;
                    String operator = description.substring(0, operatorLength);
                    filterValue = description.substring(operatorLength);
                    comparisonKindOrNull = AlternativesStringFilter.this.tryGetComparisonKind(operator);
                }
                return new DateMatcher(filterValue, comparisonKindOrNull);
            }
        });
    }

    private Matcher tryGetNumericMatcher(String s) {
        if (s.length() < 2) {
            return null;
        }
        if ("<>=".indexOf(s.charAt(0)) > -1) {
            int operatorLength = s.charAt(1) == '=' ? 2 : 1;
            String operator = s.substring(0, operatorLength);
            String filterValue = s.substring(operatorLength);
            ComparisonKind comparisonKindOrNull = this.tryGetComparisonKind(operator);
            if (comparisonKindOrNull == null) {
                return null;
            }
            try {
                double dobuleValue = Double.parseDouble(filterValue);
                return new NumericMatcher(comparisonKindOrNull, dobuleValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private ComparisonKind tryGetComparisonKind(String operator) {
        return comparisonKindByOperator.get(operator);
    }

    private Matcher getStringMatcher(String s) {
        if (this.isStartAnchored(s)) {
            if (this.isEndAnchored(s)) {
                return new EqualsMatcher(s.substring(1, s.length() - 1));
            }
            return new StartAnchorMatcher(s.substring(1));
        }
        if (this.isEndAnchored(s)) {
            return new EndAnchorMatcher(s.substring(0, s.length() - 1));
        }
        return new ContainsMatcher(s);
    }

    private boolean isStartAnchored(String s) {
        return s.startsWith(PREFIX_START_ANCHOR);
    }

    private boolean isEndAnchored(String s) {
        return s.endsWith(SUFFIX_END_ANCHOR) && !s.endsWith(SUFFIX_ESCAPED_END_ANCHOR);
    }

    public boolean passes(String value) {
        if (this.alternatives.isEmpty()) {
            return true;
        }
        for (Matcher matcher : this.alternatives) {
            if (!matcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    static {
        for (ComparisonKind comparisonKind : ComparisonKind.values()) {
            comparisonKindByOperator.put(comparisonKind.operator, comparisonKind);
        }
    }

    private static interface IMatcherFactory {
        public Matcher tryToCreate(String var1);
    }

    static class ConjunctionMatcher
    implements Matcher {
        private Matcher m1;
        private Matcher m2;

        ConjunctionMatcher(Matcher m1, Matcher m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        @Override
        public boolean matches(String value) {
            return this.m1.matches(value) && this.m2.matches(value);
        }
    }

    static class NegationMatcher
    implements Matcher {
        private Matcher delegate;

        NegationMatcher(Matcher delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean matches(String value) {
            return !this.delegate.matches(value);
        }
    }

    static class NumericMatcher
    implements Matcher {
        protected final double filterValue;
        private NumericalComparison comparison;

        NumericMatcher(NumericalComparison comparison, double filterValue) {
            this.filterValue = filterValue;
            this.comparison = comparison;
        }

        private boolean doMatch(double value) {
            return this.comparison.matches(value, this.filterValue);
        }

        @Override
        public boolean matches(String value) {
            try {
                Double d = Double.parseDouble(value);
                return this.doMatch(d);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    }

    static class DateMatcher
    implements Matcher {
        private String filter;
        private ComparisonKind comparisonKind;
        private String filterForGreater;

        DateMatcher(String filter, ComparisonKind comparison) {
            this.filter = filter;
            this.comparisonKind = comparison;
            String[] splitted = filter.split("-");
            this.filterForGreater = splitted[0] + "-" + (splitted.length > 1 ? splitted[1] : "12") + "-" + (splitted.length > 2 ? splitted[2] : "31") + " 23:59:59";
        }

        @Override
        public boolean matches(String value) {
            if (value == null) {
                return false;
            }
            if (this.comparisonKind == null || ComparisonKind.EQ.equals(this.comparisonKind)) {
                return value.startsWith(this.filter);
            }
            switch (this.comparisonKind) {
                case LT: {
                    return value.compareTo(this.filter) < 0;
                }
                case LE: {
                    return value.compareTo(this.filter) < 0 || value.startsWith(this.filter);
                }
                case GT: {
                    return value.compareTo(this.filterForGreater) > 0;
                }
                case GE: {
                    return value.compareTo(this.filter) > 0 || value.startsWith(this.filter);
                }
            }
            return false;
        }
    }

    static enum ComparisonKind implements NumericalComparison
    {
        LT("<"){

            @Override
            public boolean matches(double value, double filterValue) {
                return value < filterValue;
            }
        }
        ,
        GT(">"){

            @Override
            public boolean matches(double value, double filterValue) {
                return value > filterValue;
            }
        }
        ,
        LE("<="){

            @Override
            public boolean matches(double value, double filterValue) {
                return value <= filterValue;
            }
        }
        ,
        GE(">="){

            @Override
            public boolean matches(double value, double filterValue) {
                return value >= filterValue;
            }
        }
        ,
        EQ("="){

            @Override
            public boolean matches(double value, double filterValue) {
                return value == filterValue;
            }
        };

        private final String operator;

        private ComparisonKind(String operator) {
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }
    }

    static interface NumericalComparison {
        public boolean matches(double var1, double var3);
    }

    static class EqualsMatcher
    extends AbstractTextMatcher {
        EqualsMatcher(String filterText) {
            super(filterText);
        }

        @Override
        protected boolean doMatch(String value) {
            return value.equals(this.filterText);
        }
    }

    static class EndAnchorMatcher
    extends AbstractTextMatcher {
        EndAnchorMatcher(String filterText) {
            super(filterText);
        }

        @Override
        protected boolean doMatch(String value) {
            return value.endsWith(this.filterText);
        }
    }

    static class StartAnchorMatcher
    extends AbstractTextMatcher {
        StartAnchorMatcher(String filterText) {
            super(filterText);
        }

        @Override
        protected boolean doMatch(String value) {
            return value.startsWith(this.filterText);
        }
    }

    static class ContainsMatcher
    extends AbstractTextMatcher {
        ContainsMatcher(String filterText) {
            super(filterText);
        }

        @Override
        protected boolean doMatch(String value) {
            return value.contains(this.filterText);
        }
    }

    static abstract class AbstractTextMatcher
    implements Matcher {
        protected final String filterText;

        AbstractTextMatcher(String filterText) {
            this.filterText = filterText.toLowerCase().replace(AlternativesStringFilter.ESCAPE, "");
        }

        abstract boolean doMatch(String var1);

        @Override
        public boolean matches(String value) {
            return this.doMatch(value);
        }
    }

    static interface Matcher {
        public boolean matches(String var1);
    }
}

