/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.utilities;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class ResourceUtilities {
    public static String tryCopyResourceToTempFile(String resource, String prefix, String postfix) {
        return ResourceUtilities.tryCopyResourceToTempFile(resource, prefix, postfix, true, true, null);
    }

    public static String tryCopyResourceToTempFile(String resource, String prefix, String postfix, boolean cleanUpOldResources) {
        return ResourceUtilities.tryCopyResourceToTempFile(resource, prefix, postfix, cleanUpOldResources, true, null);
    }

    public static String tryCopyResourceToTempFile(String resource, String prefix, String postfix, boolean cleanUpOldResources, boolean verbose, String logPrefixOrNull) {
        try {
            return ResourceUtilities.copyResourceToFileImpl(resource, null, prefix, postfix, cleanUpOldResources);
        }
        catch (Exception ex) {
            if (verbose) {
                System.err.printf("%sFAILURE to copy resource '%s' to temporary file.\n", logPrefixOrNull != null ? logPrefixOrNull : "", resource);
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static String copyResourceToTempFile(String resource, String prefix, String postfix) throws IOExceptionUnchecked {
        return ResourceUtilities.copyResourceToFileImpl(resource, null, prefix, postfix, false);
    }

    public static String copyResourceToTempFile(String resource, Path destinationOrNull, String prefix, String postfix, boolean cleanUpOldResources) throws IOExceptionUnchecked {
        return ResourceUtilities.copyResourceToFileImpl(resource, null, prefix, postfix, cleanUpOldResources);
    }

    public static boolean tryCopyResourceToFile(String resource, Path filename, RandomAccessFile randomAccessFile, boolean verbose, String logPrefixOrNull) throws IOExceptionUnchecked {
        try {
            ResourceUtilities.copyResourceToFileImpl(resource, randomAccessFile, null, null, false);
            return true;
        }
        catch (Exception ex) {
            if (verbose) {
                System.err.printf("%sFAILURE to copy resource '%s' to file '%s'.\n", logPrefixOrNull != null ? logPrefixOrNull : "", resource, filename);
                ex.printStackTrace();
            }
            return false;
        }
    }

    public static void copyResourceToFile(String resource, RandomAccessFile randomAccessFile) throws IOExceptionUnchecked {
        ResourceUtilities.copyResourceToFileImpl(resource, randomAccessFile, null, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String copyResourceToFileImpl(String resource, RandomAccessFile randomAccessFileOrNull, String prefix, String postfix, boolean cleanUpOldResources) throws IOExceptionUnchecked {
        if (cleanUpOldResources) {
            ResourceUtilities.deleteOldResourceTempFiles(prefix, postfix);
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream resourceStream = ResourceUtilities.class.getResourceAsStream(resource);){
                File fileOrNull;
                if (resourceStream == null) {
                    throw new IllegalArgumentException("Resource '" + resource + "' not found.");
                }
                boolean createTmpFile = randomAccessFileOrNull == null;
                File file = fileOrNull = createTmpFile ? File.createTempFile(prefix, postfix) : null;
                if (createTmpFile) {
                    fileOrNull.deleteOnExit();
                }
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (OutputStream fileStream = fileOrNull == null ? Channels.newOutputStream(randomAccessFileOrNull.getChannel()) : new FileOutputStream(fileOrNull);){
                    long numberBytesInStream = IOUtils.copyLarge(resourceStream, fileStream);
                    if (randomAccessFileOrNull != null) {
                        randomAccessFileOrNull.setLength(numberBytesInStream);
                    }
                    fileStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
                return createTmpFile ? fileOrNull.getAbsolutePath() : null;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static void deleteOldResourceTempFiles(String prefix, String postfix) {
        WildcardFileFilter filter = new WildcardFileFilter(String.valueOf(prefix) + "*" + postfix);
        File[] fileArray = new File(System.getProperty("java.io.tmpdir")).listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }
}

