/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.Attachment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IAttachmentsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDataSetsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityTypeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IIdentifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IMaterialPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModificationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModifierHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IProjectHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPropertiesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISamplesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ITagsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.ExperimentType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.Tag;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonObject(value="as.dto.experiment.Experiment")
public class Experiment
implements Serializable,
IAttachmentsHolder,
ICodeHolder,
IDataSetsHolder,
IEntityTypeHolder,
IIdentifierHolder,
IMaterialPropertiesHolder,
IModificationDateHolder,
IModifierHolder,
IPermIdHolder,
IProjectHolder,
IPropertiesHolder,
IRegistrationDateHolder,
IRegistratorHolder,
ISamplesHolder,
ITagsHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private ExperimentFetchOptions fetchOptions;
    @JsonProperty
    private ExperimentPermId permId;
    @JsonProperty
    private ExperimentIdentifier identifier;
    @JsonProperty
    private String code;
    @JsonProperty
    private boolean frozen;
    @JsonProperty
    private boolean frozenForDataSets;
    @JsonProperty
    private boolean frozenForSamples;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Date modificationDate;
    @JsonProperty
    private ExperimentType type;
    @JsonProperty
    private Project project;
    @JsonProperty
    private List<DataSet> dataSets;
    @JsonProperty
    private List<Sample> samples;
    @JsonProperty
    private List<HistoryEntry> history;
    @JsonProperty
    private Map<String, String> properties;
    @JsonProperty
    private Map<String, Material> materialProperties;
    @JsonProperty
    private Map<String, Sample> sampleProperties;
    @JsonProperty
    private Set<Tag> tags;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private Person modifier;
    @JsonProperty
    private List<Attachment> attachments;

    @JsonIgnore
    public ExperimentFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(ExperimentFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public ExperimentPermId getPermId() {
        return this.permId;
    }

    public void setPermId(ExperimentPermId permId) {
        this.permId = permId;
    }

    @Override
    @JsonIgnore
    public ExperimentIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(ExperimentIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isFrozenForDataSets() {
        return this.frozenForDataSets;
    }

    public void setFrozenForDataSets(boolean frozenForDataSets) {
        this.frozenForDataSets = frozenForDataSets;
    }

    public boolean isFrozenForSamples() {
        return this.frozenForSamples;
    }

    public void setFrozenForSamples(boolean frozenForSamples) {
        this.frozenForSamples = frozenForSamples;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @JsonIgnore
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    @JsonIgnore
    public ExperimentType getType() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasType()) {
            return this.type;
        }
        throw new NotFetchedException("Experiment type has not been fetched.");
    }

    public void setType(ExperimentType type) {
        this.type = type;
    }

    @Override
    @JsonIgnore
    public Project getProject() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasProject()) {
            return this.project;
        }
        throw new NotFetchedException("Project has not been fetched.");
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    @JsonIgnore
    public List<DataSet> getDataSets() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasDataSets()) {
            return this.dataSets;
        }
        throw new NotFetchedException("Data sets have not been fetched.");
    }

    public void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    @JsonIgnore
    public List<Sample> getSamples() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSamples()) {
            return this.samples;
        }
        throw new NotFetchedException("Samples have not been fetched.");
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    @JsonIgnore
    public List<HistoryEntry> getHistory() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasHistory()) {
            return this.history;
        }
        throw new NotFetchedException("History have not been fetched.");
    }

    public void setHistory(List<HistoryEntry> history) {
        this.history = history;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasProperties()) {
            return this.properties;
        }
        throw new NotFetchedException("Properties have not been fetched.");
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    @JsonIgnore
    public Map<String, Material> getMaterialProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasMaterialProperties()) {
            return this.materialProperties;
        }
        throw new NotFetchedException("Material Properties have not been fetched.");
    }

    @Override
    public void setMaterialProperties(Map<String, Material> materialProperties) {
        this.materialProperties = materialProperties;
    }

    @JsonIgnore
    public Map<String, Sample> getSampleProperties() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSampleProperties()) {
            return this.sampleProperties;
        }
        throw new NotFetchedException("Sample Properties have not been fetched.");
    }

    public void setSampleProperties(Map<String, Sample> sampleProperties) {
        this.sampleProperties = sampleProperties;
    }

    @Override
    @JsonIgnore
    public Set<Tag> getTags() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasTags()) {
            return this.tags;
        }
        throw new NotFetchedException("Tags have not been fetched.");
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @Override
    @JsonIgnore
    public Person getModifier() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasModifier()) {
            return this.modifier;
        }
        throw new NotFetchedException("Modifier has not been fetched.");
    }

    public void setModifier(Person modifier) {
        this.modifier = modifier;
    }

    @Override
    @JsonIgnore
    public List<Attachment> getAttachments() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasAttachments()) {
            return this.attachments;
        }
        throw new NotFetchedException("Attachments have not been fetched.");
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.getProperties() != null ? this.getProperties().get(propertyName) : null;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(propertyName, propertyValue);
    }

    @Override
    public Material getMaterialProperty(String propertyName) {
        return this.getMaterialProperties() != null ? this.getMaterialProperties().get(propertyName) : null;
    }

    @Override
    public void setMaterialProperty(String propertyName, Material propertyValue) {
        if (this.materialProperties == null) {
            this.materialProperties = new HashMap<String, Material>();
        }
        this.materialProperties.put(propertyName, propertyValue);
    }

    public String toString() {
        return "Experiment " + this.permId;
    }
}

