/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileChunk
extends Chunk {
    private Path payloadPath;
    private ILogger logger;

    public FileChunk(int sequenceNumber, IDownloadItemId downloadItemId, String filePath, long fileOffset, int payloadLength, Path payloadPath, ILogger logger) {
        super(sequenceNumber, downloadItemId, false, filePath, fileOffset, payloadLength);
        this.payloadPath = payloadPath;
        this.logger = logger;
    }

    @Override
    public InputStream getPayload() throws DownloadException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileChannel fileChannel = FileChannel.open(this.payloadPath, StandardOpenOption.READ);){
                int payloadLength = this.getPayloadLength();
                ByteBuffer buffer = ByteBuffer.allocate(payloadLength);
                fileChannel.position(this.getFileOffset());
                fileChannel.read(buffer);
                buffer.flip();
                byte[] bytes = new byte[payloadLength];
                buffer.get(bytes);
                return new ByteArrayInputStream(bytes){

                    @Override
                    public void close() throws IOException {
                        if (FileChunk.this.logger.isEnabled(LogLevel.DEBUG)) {
                            FileChunk.this.logger.log(FileChunk.class, LogLevel.DEBUG, "Closing input stream for chunk " + FileChunk.this.getSequenceNumber());
                        }
                    }
                };
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DownloadException("Couldn't get payload: " + e.getMessage(), e, true);
        }
    }
}

