/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.reflection;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class MethodUtils {
    private MethodUtils() {
    }

    public static final String toString(Method method) {
        StringBuilder builder = new StringBuilder(method.getName()).append('(');
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            builder.append(parameterTypes[i].getSimpleName());
            if (i >= parameterTypes.length - 1) continue;
            builder.append(", ");
        }
        return builder.append(')').toString();
    }

    public static final Method getCurrentMethod() {
        return MethodUtils.getMethodOnStack(2);
    }

    public static final Method getMethodOnStack(int level) {
        assert (level > -1) : "Level must be positive.";
        StackTraceElement[] elements = new Throwable().getStackTrace();
        if (elements.length <= level) {
            throw new IndexOutOfBoundsException(String.format("Not enough elements: %d <= %d", elements.length, level));
        }
        StackTraceElement element = elements[level];
        String methodName = element.getMethodName();
        Object[] methods = null;
        try {
            for (Method method : methods = Class.forName(element.getClassName()).getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        throw new IllegalArgumentException(String.format("Method name '%s' could not be found in methods '%s'.", methodName, Arrays.toString(methods)));
    }

    public static final String describeMethod(Method method) {
        assert (method != null) : "Unspecified method";
        return method.getDeclaringClass().getSimpleName() + "." + method.getName();
    }
}

