/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.microservices.download.server.startup;

import ch.ethz.sis.microservices.download.api.configuration.Config;
import ch.ethz.sis.microservices.download.api.configuration.ServiceConfig;
import ch.ethz.sis.microservices.download.server.logging.LogManager;
import ch.ethz.sis.microservices.download.server.logging.Logger;
import ch.ethz.sis.microservices.download.server.services.Service;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ServerLauncher {
    private final Logger logger = LogManager.getLogger(ServerLauncher.class);
    private final Server server;

    public ServerLauncher(Config config) throws Exception {
        this.server = new Server(config.getPort());
        ServiceConfig[] services = config.getServices();
        ServletHandler handler = new ServletHandler();
        this.server.setHandler((Handler)handler);
        for (ServiceConfig serviceConfig : services) {
            this.logger.info("Loading Service: " + serviceConfig.getClassName() + " URL: " + serviceConfig.getUrl(), new Object[0]);
            Service service = (Service)((Object)Class.forName(serviceConfig.getClassName()).getConstructor(new Class[0]).newInstance(new Object[0]));
            service.setServiceConfig(serviceConfig);
            ServletHolder servletHolder = new ServletHolder((Servlet)service);
            handler.addServletWithMapping(servletHolder, serviceConfig.getUrl());
        }
        this.logger.info("Server Starting", new Object[0]);
        this.server.start();
        this.logger.info("Server Started", new Object[0]);
    }

    public Server getServer() {
        return this.server;
    }
}

