/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.global;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

@JsonObject(value="as.dto.global.GlobalSearchObject")
public class GlobalSearchObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private GlobalSearchObjectFetchOptions fetchOptions;
    @JsonProperty
    private GlobalSearchObjectKind objectKind;
    @JsonProperty
    private IObjectId objectPermId;
    @JsonProperty
    private IObjectId objectIdentifier;
    @JsonProperty
    private String match;
    @JsonProperty
    private double score;
    @JsonProperty
    private Experiment experiment;
    @JsonProperty
    private Sample sample;
    @JsonProperty
    private DataSet dataSet;
    @JsonProperty
    private Material material;

    @JsonIgnore
    public GlobalSearchObjectFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(GlobalSearchObjectFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @JsonIgnore
    public GlobalSearchObjectKind getObjectKind() {
        return this.objectKind;
    }

    public void setObjectKind(GlobalSearchObjectKind objectKind) {
        this.objectKind = objectKind;
    }

    @JsonIgnore
    public IObjectId getObjectPermId() {
        return this.objectPermId;
    }

    public void setObjectPermId(IObjectId objectPermId) {
        this.objectPermId = objectPermId;
    }

    @JsonIgnore
    public IObjectId getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public void setObjectIdentifier(IObjectId objectIdentifier) {
        this.objectIdentifier = objectIdentifier;
    }

    @JsonIgnore
    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = match;
    }

    @JsonIgnore
    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @JsonIgnore
    public Experiment getExperiment() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasExperiment()) {
            return this.experiment;
        }
        throw new NotFetchedException("Experiment has not been fetched.");
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    @JsonIgnore
    public Sample getSample() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSample()) {
            return this.sample;
        }
        throw new NotFetchedException("Sample has not been fetched.");
    }

    public void setSample(Sample sample) {
        this.sample = sample;
    }

    @JsonIgnore
    public DataSet getDataSet() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasDataSet()) {
            return this.dataSet;
        }
        throw new NotFetchedException("Data Set has not been fetched.");
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @JsonIgnore
    public Material getMaterial() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasMaterial()) {
            return this.material;
        }
        throw new NotFetchedException("Material has not been fetched.");
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public String toString() {
        return "GlobalSearchObject kind: " + (Object)((Object)this.objectKind) + ", permId: " + this.objectPermId + ", identifier: " + this.objectIdentifier;
    }
}

