/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.DownloadItemNotFoundException;
import ch.ethz.sis.filetransfer.DownloadPreferences;
import ch.ethz.sis.filetransfer.DownloadRange;
import ch.ethz.sis.filetransfer.DownloadServerConfig;
import ch.ethz.sis.filetransfer.DownloadServerDownload;
import ch.ethz.sis.filetransfer.DownloadSession;
import ch.ethz.sis.filetransfer.DownloadSessionId;
import ch.ethz.sis.filetransfer.DownloadState;
import ch.ethz.sis.filetransfer.DownloadStreamId;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadServer;
import ch.ethz.sis.filetransfer.IUserSessionId;
import ch.ethz.sis.filetransfer.InvalidDownloadSessionException;
import ch.ethz.sis.filetransfer.InvalidDownloadStreamException;
import ch.ethz.sis.filetransfer.InvalidUserSessionException;
import ch.ethz.sis.filetransfer.LogLevel;
import ch.ethz.sis.filetransfer.NullLogger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DownloadServer
implements IDownloadServer {
    private DownloadServerConfig config;
    private Map<DownloadSessionId, DownloadServerDownload> downloads = new ConcurrentHashMap<DownloadSessionId, DownloadServerDownload>();

    public DownloadServer(DownloadServerConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        if (config.getSessionManager() == null) {
            throw new IllegalArgumentException("Session manager cannot be null");
        }
        if (config.getChunkProvider() == null) {
            throw new IllegalArgumentException("Chunks provider cannot be null");
        }
        if (config.getSerializerProvider() == null) {
            throw new IllegalArgumentException("Serializer provider cannot be null");
        }
        if (config.getConcurrencyProvider() == null) {
            throw new IllegalArgumentException("Concurrency provider cannot be null");
        }
        if (config.getLogger() == null) {
            config.setLogger(new NullLogger());
        }
        this.config = config;
    }

    @Override
    public DownloadSession startDownloadSession(IUserSessionId userSessionId, List<IDownloadItemId> itemIds, DownloadPreferences preferences) throws DownloadItemNotFoundException, InvalidUserSessionException, DownloadException {
        if (this.config.getLogger().isEnabled(LogLevel.INFO)) {
            this.config.getLogger().log(this.getClass(), LogLevel.INFO, "startDownloadSession - user session id: " + userSessionId + ", item ids: " + itemIds + ", preferences: " + preferences);
        }
        if (userSessionId == null) {
            throw new IllegalArgumentException("User session id cannot be null");
        }
        if (itemIds == null || itemIds.isEmpty()) {
            throw new IllegalArgumentException("Item ids cannot be null or empty");
        }
        for (IDownloadItemId itemId : itemIds) {
            if (itemId != null) continue;
            throw new IllegalArgumentException("Item id cannot be null");
        }
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences cannot be null");
        }
        if (preferences.getWishedNumberOfStreams() != null && preferences.getWishedNumberOfStreams() <= 0) {
            throw new IllegalArgumentException("Wished number of streams cannot be <= 0");
        }
        this.config.getSessionManager().validateBeforeDownload(userSessionId);
        ArrayList<DownloadState> states = new ArrayList<DownloadState>();
        for (DownloadServerDownload download : this.downloads.values()) {
            states.add(download.getState());
        }
        int allowedNumberOfStreams = this.config.getConcurrencyProvider().getAllowedNumberOfStreams(userSessionId, preferences.getWishedNumberOfStreams(), states);
        if (allowedNumberOfStreams <= 0) {
            throw new DownloadException("Download server cannot provide any download streams at the moment. Please try again later.", true);
        }
        DownloadServerDownload download = new DownloadServerDownload(this.config, userSessionId, itemIds, preferences.getWishedNumberOfStreams(), allowedNumberOfStreams);
        this.downloads.put(download.getDownloadSessionId(), download);
        if (this.config.getLogger().isEnabled(LogLevel.INFO)) {
            this.config.getLogger().log(this.getClass(), LogLevel.INFO, "startDownloadSession - downloadSessionId: " + download.getDownloadSessionId() + ", ranges: " + download.getRanges() + ", allowedNumberOfStreams: " + allowedNumberOfStreams);
        }
        return new DownloadSession(download.getDownloadSessionId(), download.getRanges(), download.getStreamIds());
    }

    @Override
    public void queue(DownloadSessionId downloadSessionId, List<DownloadRange> ranges) throws InvalidUserSessionException, InvalidDownloadSessionException, DownloadException {
        if (this.config.getLogger().isEnabled(LogLevel.INFO)) {
            this.config.getLogger().log(this.getClass(), LogLevel.INFO, "queue - downloadSessionId: " + downloadSessionId + ", ranges: " + ranges);
        }
        if (downloadSessionId == null) {
            throw new IllegalArgumentException("Download session id cannot be null");
        }
        if (ranges == null || ranges.isEmpty()) {
            throw new IllegalArgumentException("Ranges cannot be null or empty");
        }
        for (DownloadRange range : ranges) {
            if (range != null) continue;
            throw new IllegalArgumentException("Range cannot be null");
        }
        DownloadServerDownload download = this.downloads.get(downloadSessionId);
        if (download == null) {
            throw new InvalidDownloadSessionException(downloadSessionId);
        }
        this.config.getSessionManager().validateDuringDownload(download.getUserSessionId());
        download.queue(ranges);
    }

    @Override
    public InputStream download(DownloadSessionId downloadSessionId, DownloadStreamId streamId, Integer numberOfChunksOrNull) throws InvalidUserSessionException, InvalidDownloadSessionException, InvalidDownloadStreamException, DownloadException {
        if (this.config.getLogger().isEnabled(LogLevel.DEBUG)) {
            this.config.getLogger().log(this.getClass(), LogLevel.DEBUG, "download - downloadSessionId: " + downloadSessionId + ", number of chunks: " + (numberOfChunksOrNull == null ? "unspecified" : numberOfChunksOrNull));
        }
        if (downloadSessionId == null) {
            throw new IllegalArgumentException("Download session id cannot be null");
        }
        if (streamId == null) {
            throw new IllegalArgumentException("Stream id cannot be null");
        }
        DownloadServerDownload download = this.downloads.get(downloadSessionId);
        if (download == null) {
            throw new InvalidDownloadSessionException(downloadSessionId);
        }
        this.config.getSessionManager().validateDuringDownload(download.getUserSessionId());
        return download.download(streamId, numberOfChunksOrNull);
    }

    @Override
    public void finishDownloadSession(DownloadSessionId downloadSessionId) throws DownloadException {
        if (this.config.getLogger().isEnabled(LogLevel.INFO)) {
            this.config.getLogger().log(this.getClass(), LogLevel.INFO, "finishDownloadSession - downloadSessionId: " + downloadSessionId);
        }
        if (downloadSessionId == null) {
            throw new IllegalArgumentException("Download session id cannot be null");
        }
        DownloadServerDownload download = this.downloads.get(downloadSessionId);
        if (download != null) {
            download.finish();
            this.downloads.remove(downloadSessionId);
        }
    }
}

