#   Copyright ETH 2025 Zürich, Scientific IT Services
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
import time
import uuid

import pytest


def test_new_object_property_type(space):
    o = space.openbis

    current_date = time.strftime("%Y-%m-%d").lower()

    # Create custom SAMPLE property type accepting ALL sample types
    property_type_code = "test_property_type_" + current_date + "_" + str(uuid.uuid4())
    pt = o.new_property_type(
        code=property_type_code,
        label='custom property of data type date',
        description='custom property created in unit test',
        dataType='SAMPLE',
    )
    pt.save()

    assert pt.code == property_type_code.upper()
    assert pt.dataType == 'SAMPLE'
    assert pt.sampleType == '(ALL)'


def test_new_object_property_type_with_sample_type(space):
    o = space.openbis

    current_date = time.strftime("%Y-%m-%d").lower()

    sample_type_code = "test_sample_type_" + current_date + "_" + str(uuid.uuid4())
    sample_type = o.new_sample_type(
        code=sample_type_code,
        generatedCodePrefix="S",
        autoGeneratedCode=True,
        listable=True,
    )
    sample_type.save()

    # Create custom SAMPLE property type accepting a single sample type
    property_type_code = "test_property_type_" + current_date + "_" + str(uuid.uuid4())
    pt = o.new_property_type(
        code=property_type_code,
        label='custom property of data type date',
        description='custom property created in unit test',
        dataType='SAMPLE',
        sampleType=sample_type.code,
    )
    pt.save()

    assert pt.code == property_type_code.upper()
    assert pt.dataType == 'SAMPLE'
    assert pt.sampleType == sample_type.code