/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.logging.LogLog;
import ch.systemsx.cisd.common.logging.ext.LoggingUtils;
import ch.systemsx.cisd.common.logging.ext.PatternFormatter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Filter;

public final class BufferedAppender
extends Handler {
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0xA00000;
    private final int maxBufferSize;
    private final ByteArrayOutputStream logRecorder = new ByteArrayOutputStream();
    private final List<Pattern> suppressedPatterns = new ArrayList<Pattern>();
    private final Pattern includePattern;
    private final Formatter formatter;
    private final List<Filter> log4jFilters = new ArrayList<Filter>();

    public BufferedAppender() {
        this(Level.DEBUG);
    }

    public BufferedAppender(Level level) {
        this("%m%n", level);
    }

    public BufferedAppender(String messagePattern, Level level) {
        this(messagePattern, level, null);
    }

    public BufferedAppender(String messagePattern, Level level, String loggerNameRegex) {
        this(new PatternFormatter(messagePattern), level, loggerNameRegex, 0xA00000);
    }

    public BufferedAppender(Formatter formatter, Level level, String loggerNameRegex) {
        this(formatter, level, loggerNameRegex, 0xA00000);
    }

    public BufferedAppender(Formatter formatter, Level level, String loggerNameRegex, int maxBufferSize) {
        this.includePattern = loggerNameRegex != null ? Pattern.compile(loggerNameRegex) : null;
        this.formatter = formatter;
        this.maxBufferSize = maxBufferSize;
        this.setLevel(LoggingUtils.mapToJULLevel(level.toInt()));
        Logger.getRootLogger().addHandler(this);
    }

    public void addRegexForLoggingEventsToBeDropped(String regex) {
        this.suppressedPatterns.add(Pattern.compile(regex));
    }

    public void addFilter(Filter filter) {
        this.log4jFilters.add(filter);
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        for (Filter filter : this.log4jFilters) {
            if (filter.decide(record) != 2) continue;
            return;
        }
        String loggerName = record.getLoggerName();
        if (this.includePattern != null && !this.includePattern.matcher(loggerName).matches()) {
            return;
        }
        String message = this.formatter.format(record);
        for (Pattern pattern : this.suppressedPatterns) {
            if (!pattern.matcher(message).find()) continue;
            return;
        }
        byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
        if (messageBytes.length > this.maxBufferSize) {
            int start = messageBytes.length - this.maxBufferSize;
            byte[] trimmed = new byte[this.maxBufferSize];
            System.arraycopy(messageBytes, start, trimmed, 0, this.maxBufferSize);
            LogLog.debug("BufferedAppender: New log message is too large; only its tail is kept.");
            messageBytes = trimmed;
            this.logRecorder.reset();
        } else if (this.logRecorder.size() + messageBytes.length > this.maxBufferSize) {
            byte[] current = this.logRecorder.toByteArray();
            int totalSize = current.length + messageBytes.length;
            int dropLength = this.maxBufferSize / 4;
            LogLog.debug("BufferedAppender: Log buffer exceeded capacity. Dropping " + dropLength + " bytes (approx. 25%% of max capacity) from oldest log entries.");
            this.logRecorder.reset();
            this.logRecorder.write(current, dropLength, current.length - dropLength);
        }
        try {
            this.logRecorder.write(messageBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void append(LogRecord record) {
        this.publish(record);
    }

    @Override
    public void flush() {
        try {
            this.logRecorder.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.logRecorder.close();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public String getLogContent() {
        return this.logRecorder.toString(StandardCharsets.UTF_8).trim();
    }

    public List<String> getLogLines() {
        String content = this.getLogContent();
        return content.isEmpty() ? List.of() : List.of(content.split("\\r?\\n"));
    }

    public void resetLogContent() {
        this.logRecorder.reset();
    }

    public final void reset() {
        Logger.getRootLogger().removeHandler(this);
        this.resetLogContent();
    }

    public String toString() {
        return this.getEncoding();
    }
}

