/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import java.io.PrintStream;

public final class LogLog {
    private static PrintStream out = System.out;
    private static boolean debugEnabled = false;
    private static boolean quietMode = false;

    private LogLog() {
    }

    public static void setDebug(boolean enabled) {
        debugEnabled = enabled;
    }

    public static void setQuietMode(boolean quiet) {
        quietMode = quiet;
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void debug(Object message) {
        if (debugEnabled && !quietMode) {
            out.println("[DEBUG] " + String.valueOf(message));
        }
    }

    public static void info(Object message) {
        if (!quietMode) {
            out.println("[INFO]  " + String.valueOf(message));
        }
    }

    public static void warn(Object message) {
        if (!quietMode) {
            out.println("[WARN]  " + String.valueOf(message));
        }
    }

    public static void error(Object message) {
        out.println("[ERROR] " + String.valueOf(message));
    }

    public static void error(Object message, Throwable t) {
        out.println("[ERROR] " + String.valueOf(message));
        t.printStackTrace(out);
    }

    public static void redirectSystemStreams() {
        System.setOut(new PrintStreamAdapter(Level.INFO));
        System.setErr(new PrintStreamAdapter(Level.ERROR));
    }

    private static class PrintStreamAdapter
    extends PrintStream {
        private final Level level;
        private final StringBuilder buffer = new StringBuilder();

        PrintStreamAdapter(Level level) {
            super(System.err);
            this.level = level;
        }

        @Override
        public void write(int b) {
            char c = (char)b;
            if (c == '\n') {
                this.flushBuffer();
            } else {
                this.buffer.append(c);
                if (this.buffer.length() > 2048) {
                    this.flushBuffer();
                }
            }
        }

        @Override
        public void flush() {
            this.flushBuffer();
        }

        private void flushBuffer() {
            if (this.buffer.length() == 0) {
                return;
            }
            String msg = this.buffer.toString().trim();
            this.buffer.setLength(0);
            if (this.level == Level.INFO) {
                LogLog.info(msg);
            } else {
                LogLog.error(msg);
            }
        }
    }

    private static enum Level {
        INFO,
        ERROR;

    }
}

