/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Priority;

public class Level
extends Priority {
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int FATAL_INT = 50000;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final int FINE_INT = 7500;
    public static final int TRACE_INT = 5000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF");
    public static final Level FATAL = new Level(50000, "FATAL");
    public static final Level ERROR = new Level(40000, "ERROR");
    public static final Level WARN = new Level(30000, "WARN");
    public static final Level INFO = new Level(20000, "INFO");
    public static final Level DEBUG = new Level(10000, "DEBUG");
    public static final Level FINE = new Level(7500, "FINE");
    public static final Level TRACE = new Level(5000, "TRACE");
    public static final Level ALL = new Level(Integer.MIN_VALUE, "ALL");
    private final String name;

    protected Level(int level, String levelStr) {
        super(level, levelStr);
        this.name = levelStr;
    }

    public boolean isGreaterOrEqual(Priority priority) {
        if (priority == null) {
            return false;
        }
        return this.toInt() >= priority.toInt();
    }

    public static Level parse(String levelStr) {
        if (levelStr == null) {
            throw new IllegalArgumentException("Level string cannot be null");
        }
        String s = levelStr.trim();
        if ("OFF".equalsIgnoreCase(s)) {
            return OFF;
        }
        if ("FATAL".equalsIgnoreCase(s)) {
            return FATAL;
        }
        if ("ERROR".equalsIgnoreCase(s)) {
            return ERROR;
        }
        if ("WARN".equalsIgnoreCase(s)) {
            return WARN;
        }
        if ("INFO".equalsIgnoreCase(s)) {
            return INFO;
        }
        if ("DEBUG".equalsIgnoreCase(s)) {
            return DEBUG;
        }
        if ("FINE".equalsIgnoreCase(s)) {
            return FINE;
        }
        if ("TRACE".equalsIgnoreCase(s)) {
            return TRACE;
        }
        if ("ALL".equalsIgnoreCase(s)) {
            return ALL;
        }
        try {
            int levelNum = Integer.parseInt(s);
            if (levelNum == Integer.MAX_VALUE) {
                return OFF;
            }
            if (levelNum == 50000) {
                return FATAL;
            }
            if (levelNum == 40000) {
                return ERROR;
            }
            if (levelNum == 30000) {
                return WARN;
            }
            if (levelNum == 20000) {
                return INFO;
            }
            if (levelNum == 10000) {
                return DEBUG;
            }
            if (levelNum == 7500) {
                return FINE;
            }
            if (levelNum == 5000) {
                return TRACE;
            }
            if (levelNum == Integer.MIN_VALUE) {
                return ALL;
            }
            return new Level(levelNum, s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unknown level: " + levelStr, e);
        }
    }

    public String getName() {
        return this.name;
    }
}

