/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.common.get;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.operation.IOperationResult;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonObject(value="as.dto.common.get.GetObjectsOperationResult")
public abstract class GetObjectsOperationResult<ID extends IObjectId, OBJECT>
implements IOperationResult {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private List<ID> ids;
    @JsonProperty
    private List<OBJECT> objects;

    protected GetObjectsOperationResult() {
    }

    public GetObjectsOperationResult(Map<ID, OBJECT> objectMap) {
        if (objectMap != null) {
            this.ids = new ArrayList<ID>();
            this.objects = new ArrayList<OBJECT>();
            for (Map.Entry<ID, OBJECT> entry : objectMap.entrySet()) {
                this.ids.add((IObjectId)entry.getKey());
                this.objects.add(entry.getValue());
            }
        }
    }

    @JsonIgnore
    public Map<ID, OBJECT> getObjectMap() {
        LinkedHashMap<IObjectId, OBJECT> objectMap = new LinkedHashMap<IObjectId, OBJECT>();
        if (this.ids != null && this.objects != null) {
            Iterator<ID> idIter = this.ids.iterator();
            Iterator<OBJECT> objectIter = this.objects.iterator();
            while (idIter.hasNext() && objectIter.hasNext()) {
                objectMap.put((IObjectId)idIter.next(), objectIter.next());
            }
        }
        return objectMap;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public String toString() {
        int idsSize = this.ids != null ? this.ids.size() : 0;
        int objectsSize = this.objects != null ? this.objects.size() : 0;
        int size = Math.min(idsSize, objectsSize);
        return this.getClass().getSimpleName() + " " + size + " object(s)";
    }
}

