/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.ObjectToString;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

@JsonObject(value="as.dto.common.update.ListUpdateValue")
public class ListUpdateValue<ADD, REMOVE, SET, ACTION>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ListUpdateAction<ACTION>> actions = new LinkedList<ListUpdateAction<ACTION>>();

    public void setActions(List<ListUpdateAction<ACTION>> actions) {
        this.actions = new LinkedList<ListUpdateAction<ACTION>>(actions);
    }

    public List<ListUpdateAction<ACTION>> getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.getActions() != null && this.getActions().size() > 0;
    }

    public void remove(REMOVE ... items) {
        ListUpdateActionRemove action = new ListUpdateActionRemove();
        action.setItems(Arrays.asList(items));
        this.actions.add(action);
    }

    @JsonIgnore
    public Collection<REMOVE> getRemoved() {
        LinkedHashSet<ACTION> items = new LinkedHashSet<ACTION>();
        for (ListUpdateAction<ACTION> action : this.actions) {
            if (!(action instanceof ListUpdateActionRemove)) continue;
            items.addAll(action.getItems());
        }
        return items;
    }

    public void add(ADD ... items) {
        ListUpdateActionAdd action = new ListUpdateActionAdd();
        action.setItems(Arrays.asList(items));
        this.actions.add(action);
    }

    @JsonIgnore
    public Collection<ADD> getAdded() {
        LinkedHashSet<ACTION> items = new LinkedHashSet<ACTION>();
        for (ListUpdateAction<ACTION> action : this.actions) {
            if (!(action instanceof ListUpdateActionAdd)) continue;
            items.addAll(action.getItems());
        }
        return items;
    }

    public void set(SET ... items) {
        ListUpdateActionSet action = new ListUpdateActionSet();
        if (items == null) {
            action.setItems(Collections.emptyList());
        } else {
            action.setItems(Arrays.asList(items));
        }
        this.actions.add(action);
    }

    @JsonIgnore
    public Collection<SET> getSet() {
        LinkedHashSet<ACTION> items = new LinkedHashSet<ACTION>();
        for (ListUpdateAction<ACTION> action : this.actions) {
            if (!(action instanceof ListUpdateActionSet)) continue;
            items.addAll(action.getItems());
        }
        return items;
    }

    public String toString() {
        return new ObjectToString(this).append("added", this.getAdded()).append("removed", this.getRemoved()).append("set", this.getSet()).toString();
    }

    @JsonObject(value="as.dto.common.update.ListUpdateActionSet")
    public static class ListUpdateActionSet<SET>
    extends ListUpdateAction<SET> {
        private static final long serialVersionUID = 1L;
    }

    @JsonObject(value="as.dto.common.update.ListUpdateActionRemove")
    public static class ListUpdateActionRemove<REMOVE>
    extends ListUpdateAction<REMOVE> {
        private static final long serialVersionUID = 1L;
    }

    @JsonObject(value="as.dto.common.update.ListUpdateActionAdd")
    public static class ListUpdateActionAdd<ADD>
    extends ListUpdateAction<ADD> {
        private static final long serialVersionUID = 1L;
    }

    @JsonObject(value="as.dto.common.update.ListUpdateAction")
    public static class ListUpdateAction<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Collection<? extends T> items;

        public Collection<? extends T> getItems() {
            return this.items;
        }

        public void setItems(Collection<? extends T> items) {
            this.items = items;
        }
    }
}

