/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.reflection;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.reflection.CollectionMapping;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public final class BeanUtils {
    private static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final AnnotationMap EMPTY_ANNOTATION_MAP = new EmptyAnnotationMap();
    private static final Converter NULL_CONVERTER = new Converter(){};
    static final Set<Class> immutableTypes = new LinkedHashSet<Class>(Arrays.asList(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, String.class, Date.class));
    private static final Map<Class<?>, Collection<Class<?>>> sourceBeanClassesCache = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, Method[]> converterMethodsCache = Collections.synchronizedMap(new HashMap());

    private BeanUtils() {
    }

    public static final <T, S> List<T> createBeanList(Class<T> clazz, Iterable<S> source) {
        return BeanUtils.createBeanList(clazz, source, null);
    }

    public static final <T, S> T[] createBeanArray(Class<T> clazz, Collection<S> source) {
        return BeanUtils.createBeanArray(clazz, source, null);
    }

    public static final <T, S> T[] createBeanArray(Class<T> clazz, S[] source) {
        return BeanUtils.createBeanArray(clazz, Arrays.asList(source), null);
    }

    public static final <T, S> T[] createBeanArray(Class<T> clazz, S[] source, Converter converter) {
        return BeanUtils.createBeanArray(clazz, Arrays.asList(source), converter);
    }

    public static final <T, S> T[] createBeanArray(Class<T> clazz, Collection<S> source, Converter converter) {
        assert (clazz != null) : "Unspecified class";
        if (source == null) {
            return null;
        }
        T[] result = BeanUtils.createArrayOfType(clazz, source.size());
        int i = 0;
        for (S element : source) {
            result[i] = BeanUtils.createBean(clazz, element, converter);
            ++i;
        }
        return result;
    }

    public static <T, S> T[] createBeanArray(Class<T> clazz, Iterable<S> source, Converter converter) {
        List<T> list = BeanUtils.createBeanList(clazz, source, converter);
        T[] result = BeanUtils.createArrayOfType(clazz, list.size());
        return list.toArray(result);
    }

    public static final <T, S> List<T> createBeanList(Class<T> clazz, Iterable<S> source, Converter converter) {
        assert (clazz != null);
        if (source == null) {
            return null;
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (S element : source) {
            resultList.add(BeanUtils.createBean(clazz, element, converter));
        }
        return resultList;
    }

    public static <T> T fillBean(Class<T> beanClass, T beanInstance, Object sourceBean) {
        return BeanUtils.fillBean(beanClass, beanInstance, new IdentityHashMap<Object, Object>(), sourceBean, EMPTY_ANNOTATION_MAP, NULL_CONVERTER);
    }

    public static <T> T createBean(Class<T> beanClass, Object sourceBean) {
        return BeanUtils.fillBean(beanClass, null, new IdentityHashMap<Object, Object>(), sourceBean, EMPTY_ANNOTATION_MAP, NULL_CONVERTER);
    }

    public static <T> T fillBean(Class<T> beanClass, T beanInstance, Object sourceBean, Converter converter) {
        Converter c = converter;
        if (c == null) {
            c = NULL_CONVERTER;
        }
        return BeanUtils.fillBean(beanClass, beanInstance, new IdentityHashMap<Object, Object>(), sourceBean, EMPTY_ANNOTATION_MAP, c);
    }

    public static <T> T createBean(Class<T> beanClass, Object sourceBean, Converter converter) {
        return BeanUtils.createBean(beanClass, new IdentityHashMap<Object, Object>(), sourceBean, converter);
    }

    private static <T> T createBean(Class<T> beanClass, Map<Object, Object> repository, Object sourceBean, Converter converter) {
        Converter c = converter;
        if (c == null) {
            c = NULL_CONVERTER;
        }
        return BeanUtils.fillBean(beanClass, null, repository, sourceBean, EMPTY_ANNOTATION_MAP, c);
    }

    private static <T> T fillBean(Class<T> beanClass, T beanInstance, Map<Object, Object> repository, Object sourceBean, AnnotationMap setterAnnotations, Converter converter) {
        assert (beanClass != null) : "undefined bean class";
        assert (setterAnnotations != null) : "undefined setter annotations for " + beanClass;
        assert (converter != null) : "undefined converter for " + beanClass;
        if (sourceBean == null) {
            return null;
        }
        Object convertedBean = repository.get(sourceBean);
        if (convertedBean != null) {
            return (T)convertedBean;
        }
        try {
            Object destinationBean;
            T t = destinationBean = beanInstance != null ? beanInstance : BeanUtils.instantiateBean(beanClass, sourceBean, setterAnnotations);
            if (BeanUtils.isArray(destinationBean)) {
                if (BeanUtils.isArray(sourceBean)) {
                    destinationBean = BeanUtils.copyArrayToArray(destinationBean, repository, sourceBean, converter);
                } else if (BeanUtils.isCollection(sourceBean)) {
                    destinationBean = BeanUtils.copyCollectionToArray(destinationBean, repository, (Collection)sourceBean, converter);
                }
            } else if (BeanUtils.isCollection(destinationBean)) {
                if (BeanUtils.isArray(sourceBean)) {
                    BeanUtils.copyArrayToCollection((Collection)destinationBean, repository, sourceBean, setterAnnotations, converter);
                } else if (BeanUtils.isCollection(sourceBean)) {
                    BeanUtils.copyCollectionToCollection((Collection)destinationBean, repository, (Collection)sourceBean, setterAnnotations, converter);
                }
            } else {
                repository.put(sourceBean, destinationBean);
                if (sourceBean instanceof Properties) {
                    BeanUtils.copyBeanFromProperties(destinationBean, (Properties)sourceBean, converter);
                } else {
                    BeanUtils.copyBean(destinationBean, repository, sourceBean, converter);
                }
            }
            return destinationBean;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)cause);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static boolean isCollection(Object o) {
        return o instanceof Collection;
    }

    private static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    private static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    private static boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    private static <T> T instantiateBean(Class<T> beanClass, Object sourceBean, AnnotationMap setterAnnotations) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceBean == null) {
            return null;
        }
        boolean beanIsArray = BeanUtils.isArray(beanClass);
        boolean beanIsCollection = BeanUtils.isCollection(beanClass);
        if (beanIsArray || beanIsCollection) {
            Integer size = BeanUtils.getSize(sourceBean);
            if (size == null) {
                return null;
            }
            if (beanIsArray) {
                return BeanUtils.createArray(beanClass, size);
            }
            if (beanIsCollection) {
                return BeanUtils.createCollection(size, setterAnnotations);
            }
        }
        return beanClass.newInstance();
    }

    private static Integer getSize(Object o) {
        if (BeanUtils.isArray(o)) {
            return Array.getLength(o);
        }
        if (BeanUtils.isCollection(o)) {
            return ((Collection)o).size();
        }
        return null;
    }

    private static <T> T createArray(Class<T> beanClass, int length) throws NegativeArraySizeException {
        return (T)Array.newInstance(beanClass.getComponentType(), length);
    }

    private static <E> E[] createArrayOfType(Class<E> elemClass, int length) throws NegativeArraySizeException {
        return (Object[])Array.newInstance(elemClass, length);
    }

    private static final <T> T createCollection(int size, AnnotationMap setterAnnotations) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        CollectionMapping mapping = BeanUtils.getCollectionMapping(setterAnnotations);
        try {
            Constructor<? extends Collection> constructorWithSize = mapping.collectionClass().getConstructor(Integer.TYPE);
            return BeanUtils.constructCollection(constructorWithSize, size);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.constructCollection(mapping.collectionClass());
        }
    }

    private static <T> T constructCollection(Constructor<? extends Collection> constructorWithSize, int size) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (T)constructorWithSize.newInstance(size);
    }

    private static final <T> T constructCollection(Class<? extends Collection> collectionClazz) throws InstantiationException, IllegalAccessException {
        return (T)collectionClazz.newInstance();
    }

    private static final <T> T copyArrayToArray(T destination, Map<Object, Object> repository, Object source, Converter converter) throws IllegalAccessException, InvocationTargetException {
        if (destination == null) {
            return null;
        }
        Class<?> componentType = destination.getClass().getComponentType();
        int length = Array.getLength(source);
        Object returned = Array.getLength(destination) < length ? Array.newInstance(componentType, length) : destination;
        if (immutableTypes.contains(componentType)) {
            if (componentType == source.getClass().getComponentType()) {
                System.arraycopy(source, 0, returned, 0, length);
            } else {
                for (int index = 0; index < length; ++index) {
                    Object sourceElement = Array.get(source, index);
                    Array.set(returned, index, sourceElement);
                }
            }
        } else {
            for (int index = 0; index < length; ++index) {
                Object sourceElement = Array.get(source, index);
                Object destinationElement = BeanUtils.createBean(componentType, repository, sourceElement, converter);
                Array.set(returned, index, destinationElement);
            }
        }
        return returned;
    }

    private static final <T> T[] copyCollectionToArray(Object destination, Map<Object, Object> repository, Collection<T> source, Converter converter) throws IllegalAccessException, InvocationTargetException {
        if (destination == null) {
            return null;
        }
        Class<?> componentType = destination.getClass().getComponentType();
        int size = source.size();
        Object[] returned = Array.getLength(destination) < size ? (Object[])Array.newInstance(componentType, size) : (Object[])destination;
        if (immutableTypes.contains(componentType)) {
            int index = 0;
            for (T sourceElement : source) {
                Array.set(returned, index++, sourceElement);
            }
        } else {
            int index = 0;
            for (T sourceElement : source) {
                Object destinationElement = BeanUtils.createBean(componentType, repository, sourceElement, converter);
                Array.set(returned, index++, destinationElement);
            }
        }
        return returned;
    }

    private static void copyArrayToCollection(Collection<?> destination, Map<Object, Object> repository, Object source, AnnotationMap setterAnnotations, Converter converter) {
        if (destination == null) {
            return;
        }
        Class<?> componentType = BeanUtils.getCollectionComponentType(setterAnnotations);
        int length = BeanUtils.getSize(source);
        if (immutableTypes.contains(componentType)) {
            for (int index = 0; index < length; ++index) {
                Object sourceElement = Array.get(source, index);
                BeanUtils.addToUntypedCollection(destination, sourceElement);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                Object sourceElement = Array.get(source, index);
                Object destinationElement = BeanUtils.createBean(componentType, repository, sourceElement, converter);
                BeanUtils.addToUntypedCollection(destination, destinationElement);
            }
        }
    }

    private static void copyCollectionToCollection(Collection<?> destination, Map<Object, Object> repository, Collection<?> source, AnnotationMap setterAnnotations, Converter converter) {
        if (destination == null) {
            return;
        }
        Class<?> componentType = BeanUtils.getCollectionComponentType(setterAnnotations);
        if (immutableTypes.contains(componentType)) {
            for (Object sourceElement : source) {
                BeanUtils.addToUntypedCollection(destination, sourceElement);
            }
        } else {
            for (Object sourceElement : source) {
                Object destinationElement = BeanUtils.createBean(componentType, repository, sourceElement, converter);
                BeanUtils.addToUntypedCollection(destination, destinationElement);
            }
        }
    }

    private static void addToUntypedCollection(Collection destination, Object element) {
        destination.add(element);
    }

    private static Class<?> getCollectionComponentType(AnnotationMap setterAnnotations) {
        return BeanUtils.getCollectionMapping(setterAnnotations).elementClass();
    }

    private static CollectionMapping getCollectionMapping(AnnotationMap setterAnnotations) {
        CollectionMapping mapping = setterAnnotations.getAnnotation(CollectionMapping.class);
        if (mapping == null) {
            throw new IllegalArgumentException("No collection mapping specified for '" + setterAnnotations.getAnnotatedEntity() + "'.");
        }
        return mapping;
    }

    private static <T> void copyBeanFromProperties(T destination, Properties source, Converter converter) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (destination == null) {
            return;
        }
        Collection<Method> destinationSetters = BeanUtils.scanForPublicMethods(destination, SETTER_PREFIX, 1).values();
        for (Method setter : destinationSetters) {
            Object valueOrNull = null;
            Method converterMethod = BeanUtils.getConverterMethod(setter, source, converter);
            if (converterMethod != null) {
                valueOrNull = converterMethod.invoke((Object)converter, source);
            } else {
                String propertyKey = Character.toLowerCase(setter.getName().charAt(3)) + setter.getName().substring("setX".length());
                String propertyValueOrNull = (String)source.get(propertyKey);
                if (propertyValueOrNull != null) {
                    Class<?> resultType = setter.getParameterTypes()[0];
                    if (resultType == String.class) {
                        valueOrNull = propertyValueOrNull;
                    } else if (resultType == Boolean.TYPE || resultType == Boolean.class) {
                        valueOrNull = Boolean.parseBoolean(propertyValueOrNull);
                    } else if (resultType == Integer.TYPE || resultType == Integer.class) {
                        valueOrNull = Integer.parseInt(propertyValueOrNull);
                    } else if (resultType == Float.TYPE || resultType == Float.class) {
                        valueOrNull = Float.valueOf(Float.parseFloat(propertyValueOrNull));
                    } else if (resultType == Long.TYPE || resultType == Long.class) {
                        valueOrNull = Long.parseLong(propertyValueOrNull);
                    } else if (resultType == Double.TYPE || resultType == Double.class) {
                        valueOrNull = Double.parseDouble(propertyValueOrNull);
                    } else if (resultType == Short.TYPE || resultType == Short.class) {
                        valueOrNull = Short.parseShort(propertyValueOrNull);
                    } else if (resultType == Byte.TYPE || resultType == Byte.class) {
                        valueOrNull = Byte.parseByte(propertyValueOrNull);
                    }
                }
            }
            if (valueOrNull == null) continue;
            setter.invoke(destination, valueOrNull);
        }
    }

    private static <T> void copyBean(T destination, Map<Object, Object> repository, Object source, Converter converter) throws IllegalAccessException, InvocationTargetException {
        if (destination == null) {
            return;
        }
        Collection<Method> destinationSetters = BeanUtils.scanForPublicMethods(destination, SETTER_PREFIX, 1).values();
        Map<String, Method> destinationGetters = BeanUtils.scanForPublicMethods(destination, GETTER_PREFIX, 0);
        Map<String, Method> sourceGetters = BeanUtils.scanForPublicMethods(source, GETTER_PREFIX, 0);
        BeanUtils.scanForPublicMethods(source, sourceGetters, BOOLEAN_GETTER_PREFIX, 0, Boolean.TYPE, Boolean.class);
        for (Method setter : destinationSetters) {
            T newBean = BeanUtils.emergeNewBean(setter, source, repository, destination, sourceGetters, destinationGetters, converter);
            if (newBean == null) continue;
            try {
                setter.invoke(destination, newBean);
            }
            catch (IllegalArgumentException ex) {
                String defaultJavaArgumentTypeMismatchMessage = "argument type mismatch";
                if ("argument type mismatch".equals(ex.getMessage())) {
                    throw new IllegalArgumentException("argument type mismatch: method '" + setter.toGenericString() + "': cannot assign from '" + newBean.getClass().getCanonicalName() + "'.");
                }
                throw ex;
            }
        }
    }

    private static <T> T emergeNewBean(Method setter, Object source, Map<Object, Object> repository, T destination, Map<String, Method> sourceGetters, Map<String, Method> destinationGetters, Converter converter) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        SetterAnnotationMap annotationMap = new SetterAnnotationMap(setter);
        Method converterMethod = BeanUtils.getConverterMethod(setter, source, converter);
        if (converterMethod != null) {
            return (T)converterMethod.invoke((Object)converter, source);
        }
        Object oldBean = BeanUtils.getOldBean(setter, sourceGetters, source);
        if (oldBean == null) {
            return null;
        }
        Class<?> parameterType = setter.getParameterTypes()[0];
        if (parameterType.isPrimitive() || immutableTypes.contains(parameterType) || parameterType.isEnum() || oldBean.getClass().isAssignableFrom(parameterType)) {
            return (T)oldBean;
        }
        Object destinationOldBean = BeanUtils.getOldBean(setter, destinationGetters, destination);
        return (T)BeanUtils.fillBean(parameterType, destinationOldBean, repository, oldBean, annotationMap, converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object getOldBean(Method setter, Map<String, Method> getters, Object bean2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getter = BeanUtils.getGetter(setter, getters);
        if (getter == null) {
            return null;
        }
        boolean isAccessible = getter.isAccessible();
        if (!isAccessible) {
            getter.setAccessible(true);
        }
        try {
            Object oldBean;
            Object object = oldBean = getter.invoke(bean2, ArrayUtils.EMPTY_OBJECT_ARRAY);
            return object;
        }
        finally {
            if (!isAccessible) {
                getter.setAccessible(false);
            }
        }
    }

    private static Method getConverterMethod(Method setter, Object sourceBean, Converter converter) {
        if (converter != NULL_CONVERTER) {
            String methodName = "convertTo" + setter.getName().substring(SETTER_PREFIX.length());
            Class<?> converterClass = converter.getClass();
            Class<?> beanClass = sourceBean.getClass();
            Collection<Class<?>> classes = sourceBeanClassesCache.get(beanClass);
            if (classes == null) {
                classes = ClassUtils.gatherAllCastableClassesAndInterfacesFor(sourceBean);
                sourceBeanClassesCache.put(beanClass, classes);
            }
            for (Class<?> clazz : classes) {
                Method[] methods = converterMethodsCache.get(converterClass);
                if (methods == null) {
                    methods = converterClass.getMethods();
                    converterMethodsCache.put(converterClass, methods);
                }
                for (Method method : methods) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (!methodName.equals(method.getName()) || parameterTypes.length != 1 || !parameterTypes[0].equals(clazz)) continue;
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method;
                }
            }
        }
        return null;
    }

    private static Method getGetter(Method setter, Map<String, Method> sourceGetters) {
        String propertyName = setter.getName().substring(SETTER_PREFIX.length());
        Method getter = sourceGetters.get(GETTER_PREFIX + propertyName);
        if (getter != null) {
            return getter;
        }
        Class<?> type = setter.getParameterTypes()[0];
        if (type == Boolean.TYPE || type == Boolean.class) {
            return sourceGetters.get(BOOLEAN_GETTER_PREFIX + propertyName);
        }
        return null;
    }

    private static Map<String, Method> scanForPublicMethods(Object bean2, String prefix, int numberOfParameters) {
        LinkedHashMap<String, Method> methodMap = new LinkedHashMap<String, Method>();
        BeanUtils.scanForPublicMethods(bean2, methodMap, prefix, numberOfParameters, (Set)null);
        return methodMap;
    }

    private static void scanForPublicMethods(Object bean2, Map<String, Method> methodMap, String prefix, int numberOfParameters, Class<?> ... returnValueTypes) {
        List<Class<?>> list = Arrays.asList(returnValueTypes);
        BeanUtils.scanForPublicMethods(bean2, methodMap, prefix, numberOfParameters, new LinkedHashSet(list));
    }

    private static void scanForPublicMethods(Object bean2, Map<String, Method> methodMap, String prefix, int numberOfParameters, Set<Class<?>> returnValueTypes) {
        for (Method method : bean2.getClass().getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith(prefix) || method.getParameterTypes().length != numberOfParameters || !Modifier.isPublic(method.getModifiers()) || returnValueTypes != null && !returnValueTypes.contains(method.getReturnType())) continue;
            methodMap.put(methodName, method);
        }
    }

    public static final Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        try {
            LinkedHashMap<String, PropertyDescriptor> map = new LinkedHashMap<String, PropertyDescriptor>();
            ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>(Arrays.asList(Introspector.getBeanInfo(clazz).getPropertyDescriptors()));
            for (PropertyDescriptor descriptor : descriptors) {
                if (descriptor.getWriteMethod() == null) continue;
                map.put(descriptor.getName(), descriptor);
            }
            return map;
        }
        catch (IntrospectionException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T clone(T bean2) throws IOException, ClassNotFoundException {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(bean2);
            oos.flush();
            ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            Object object = ois.readObject();
            return (T)object;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (ois != null) {
                ois.close();
            }
        }
    }

    public static interface Converter {
    }

    private static class SetterAnnotationMap
    implements AnnotationMap {
        private final Method setterMethod;

        SetterAnnotationMap(Method setterMethod) {
            assert (setterMethod != null);
            this.setterMethod = setterMethod;
        }

        @Override
        public String getAnnotatedEntity() {
            return this.setterMethod.toGenericString();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClazz) {
            return this.setterMethod.getAnnotation(annotationClazz);
        }
    }

    private static class EmptyAnnotationMap
    implements AnnotationMap {
        private EmptyAnnotationMap() {
        }

        @Override
        public String getAnnotatedEntity() {
            return "GENERIC";
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClazz) {
            return null;
        }
    }

    public static interface AnnotationMap {
        public String getAnnotatedEntity();

        public <T extends Annotation> T getAnnotation(Class<T> var1);
    }
}

