/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Operators;

public abstract class AbstractListenerReadPublisher<T>
implements Publisher<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private volatile long demand;
    private static final AtomicLongFieldUpdater<AbstractListenerReadPublisher> DEMAND_FIELD_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractListenerReadPublisher.class, "demand");
    @Nullable
    private Subscriber<? super T> subscriber;

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " subscribe: " + subscriber);
        }
        this.state.get().subscribe(this, subscriber);
    }

    public final void onDataAvailable() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " onDataAvailable");
        }
        this.state.get().onDataAvailable(this);
    }

    public void onAllDataRead() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " onAllDataRead");
        }
        this.state.get().onAllDataRead(this);
    }

    public final void onError(Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.state + " onError: " + t);
        }
        this.state.get().onError(this, t);
    }

    protected abstract void checkOnDataAvailable();

    @Nullable
    protected abstract T read() throws IOException;

    private boolean readAndPublish() throws IOException {
        long r;
        while ((r = this.demand) > 0L) {
            T data = this.read();
            if (data != null) {
                if (r != Long.MAX_VALUE) {
                    DEMAND_FIELD_UPDATER.addAndGet(this, -1L);
                }
                Assert.state(this.subscriber != null, "No subscriber");
                this.subscriber.onNext(data);
                continue;
            }
            return true;
        }
        return false;
    }

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            <T> void subscribe(AbstractListenerReadPublisher<T> publisher, Subscriber<? super T> subscriber) {
                Assert.notNull(publisher, "Publisher must not be null");
                Assert.notNull(subscriber, "Subscriber must not be null");
                if (!((AbstractListenerReadPublisher)publisher).changeState(this, 1.NO_DEMAND)) {
                    throw new IllegalStateException(this.toString());
                }
                ReadSubscription subscription = new ReadSubscription(publisher);
                ((AbstractListenerReadPublisher)publisher).subscriber = subscriber;
                subscriber.onSubscribe((Subscription)subscription);
            }
        }
        ,
        NO_DEMAND{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap((AtomicLongFieldUpdater)DEMAND_FIELD_UPDATER, publisher, (long)n);
                    if (((AbstractListenerReadPublisher)publisher).changeState(this, 2.DEMAND)) {
                        publisher.checkOnDataAvailable();
                    }
                }
            }
        }
        ,
        DEMAND{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap((AtomicLongFieldUpdater)DEMAND_FIELD_UPDATER, publisher, (long)n);
                }
            }

            @Override
            <T> void onDataAvailable(AbstractListenerReadPublisher<T> publisher) {
                if (((AbstractListenerReadPublisher)publisher).changeState(this, 3.READING)) {
                    try {
                        boolean demandAvailable = ((AbstractListenerReadPublisher)publisher).readAndPublish();
                        if (demandAvailable) {
                            ((AbstractListenerReadPublisher)publisher).changeState(3.READING, 3.DEMAND);
                            publisher.checkOnDataAvailable();
                        } else {
                            ((AbstractListenerReadPublisher)publisher).changeState(3.READING, 3.NO_DEMAND);
                        }
                    }
                    catch (IOException ex) {
                        publisher.onError(ex);
                    }
                }
            }
        }
        ,
        READING{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap((AtomicLongFieldUpdater)DEMAND_FIELD_UPDATER, publisher, (long)n);
                }
            }
        }
        ,
        COMPLETED{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
            }

            @Override
            <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
            }

            @Override
            <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
            }

            @Override
            <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable t) {
            }
        };


        <T> void subscribe(AbstractListenerReadPublisher<T> publisher, Subscriber<? super T> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
            throw new IllegalStateException(this.toString());
        }

        <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
            ((AbstractListenerReadPublisher)publisher).changeState(this, State.COMPLETED);
        }

        <T> void onDataAvailable(AbstractListenerReadPublisher<T> publisher) {
        }

        <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
            if (((AbstractListenerReadPublisher)publisher).changeState(this, State.COMPLETED) && ((AbstractListenerReadPublisher)publisher).subscriber != null) {
                ((AbstractListenerReadPublisher)publisher).subscriber.onComplete();
            }
        }

        <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable t) {
            if (((AbstractListenerReadPublisher)publisher).changeState(this, State.COMPLETED) && ((AbstractListenerReadPublisher)publisher).subscriber != null) {
                ((AbstractListenerReadPublisher)publisher).subscriber.onError(t);
            }
        }
    }

    private static final class ReadSubscription
    implements Subscription {
        private final AbstractListenerReadPublisher<?> publisher;

        public ReadSubscription(AbstractListenerReadPublisher<?> publisher) {
            this.publisher = publisher;
        }

        public final void request(long n) {
            if (this.publisher.logger.isTraceEnabled()) {
                this.publisher.logger.trace((Object)((Object)this.state()) + " request: " + n);
            }
            this.state().request(this.publisher, n);
        }

        public final void cancel() {
            if (this.publisher.logger.isTraceEnabled()) {
                this.publisher.logger.trace((Object)((Object)this.state()) + " cancel");
            }
            this.state().cancel(this.publisher);
        }

        private State state() {
            return (State)((Object)((AbstractListenerReadPublisher)this.publisher).state.get());
        }
    }
}

